(* file: functionlang/semantic/Pascal/resolve.p *)

#include "semantic.h"
#include "semantic.i"
#include "sem2.h"

procedure resolveexp(var theexp: expression;
				var theparameters: SEQformalparameter);
var Aformalparameter: formalparameter;
	i: integer;
begin
	case theexp^.Eexpression of
	Kexpressionconstant: (* do nothing *);
	KexpressionformalparameterRef:
		for i := 1 to lengthSEQformalparameter(theparameters) do begin
			Aformalparameter := ithinSEQformalparameter(theparameters, i);
			if Aformalparameter^.synname^.lextoken
				 = theexp^.VformalparameterRef^.synname^.lextoken
			then theexp^.VformalparameterRef^.sementity := Aformalparameter;
			end;
	Kexpressionoperation: case theexp^.Voperation^.Eoperation of
		Koperationbinaryoperation: begin		
			resolveexp(theexp^.Voperation^.Vbinaryoperation^.synleft,
								theparameters);
			resolveexp(theexp^.Voperation^.Vbinaryoperation^.synright,
								theparameters);
			end;
		Koperationunaryoperation:
			resolveexp(theexp^.Voperation^.Vunaryoperation^.synargument,
								theparameters);
		end
	end
end;

(* the procedure for resolving parameter references *)

procedure resolvereferences(*var thefunction: function*);
begin
	resolveexp(thefunction^.syndefinition, thefunction^.synparameters);
end;
