(* file: functionlang/semantic/Pascal/main.p *)

program semantic (input, output);
#include "semantic.h"
#include "sem2.h"

var ATfunction: Tfunction;
	thefunctions: functions;
	returntype: types;
	exptype: types;
	i: integer;
	ReaderOK: boolean;

#include "semantic.i"

(* the main driver for the expression typing program *)
begin
	(* read in the input data structure *)

	thefunctions := inputport(input, ReaderOK);

	if not ReaderOK then halt;

	(* for each function, resolve parameter references *)

	for i := 1 to lengthSEQTfunction(thefunctions^.synfuncseq) do begin
		ATfunction:= ithinSEQTfunction(thefunctions^.synfuncseq, i);
		resolvereferences(ATfunction);
	end;

	(* for each function, add types to expressions and check for type *)
	(* conflict between function return value and body of function *)

	for i := 1 to lengthSEQTfunction(thefunctions^.synfuncseq) do begin
	      	ATfunction:= ithinSEQTfunction(thefunctions^.synfuncseq, i);

	      	expressiontype(ATfunction^.syndefinition);
		returntype := ATfunction^.synreturntype;
		exptype := ATfunction^.syndefinition^.semexptype;

		(* Check result type, permitting integers to be coerced into reals *)
		if (returntype^.Etypes = Ktypesint)
			and (exptype^.Etypes <> Ktypesint)
		then writeln('semantic: function', ' ''',
				StringTopacked(ATfunction^.synname^.lextoken),
				''' returns incompatible type');
	end;

	(* write out the attributed data structure *)

	outputport(output, thefunctions);
end.
