/* file: functionlang/semantic/C/typing.c */

#include "semantic.h"
#include <stdio.h>

/* the procedure for expression typing */
expression_type (the_exp)
expression the_exp;
{
    expression left_exp;  /* for de-referencing left exp of binary op */
    expression right_exp; /* for de-referencing right exp of binary op */
    expression arg_exp;   /* for de-referencing argument of unary op */
    types left_type;
    types right_type;
    types arg_type;
    types result_type;
    
    switch (typeof(the_exp)) {
    case Kinteger_constant:
        the_exp.Vinteger_constant->sem_exp_type.VTint = NTint;
        break;
        
    case Kreal_constant:
        the_exp.Vreal_constant->sem_exp_type.Vreal = Nreal;
        break;

    case Kformal_parameterRef:
        the_exp.Vformal_parameterRef->sem_exp_type =
            the_exp.Vformal_parameterRef->sem_entity->syn_param_type;
        break;
        
    case Kbinary_operation:
        left_exp = the_exp.Vbinary_operation->syn_left;
        right_exp = the_exp.Vbinary_operation->syn_right;
        expression_type(left_exp);
        expression_type(right_exp);
        left_type = left_exp.IDLclassCommon->sem_exp_type;
        right_type = right_exp.IDLclassCommon->sem_exp_type;

        switch (typeof (the_exp.Vbinary_operation->syn_op)) {
        case Kplus:
        case Kminus:
        case Ktimes:
            if ((typeof (left_type) != KTint) || (typeof (right_type) != KTint))
                result_type.Vreal = Nreal;
            else
                result_type.VTint = NTint;
            break;

        case Kdivide:
            result_type.Vreal = Nreal;
            break;

        default:
            fprintf (stderr,
                    "typing: unknown binary operator\n");
            break;
        }
        the_exp.Vunary_operation->sem_exp_type = result_type;
        break;
    case Kunary_operation:
        arg_exp = the_exp.Vunary_operation->syn_argument;
        expression_type(arg_exp);
        arg_type = arg_exp.IDLclassCommon->sem_exp_type;

        if (typeof (arg_type) != KTint)
            result_type.Vreal = Nreal;
        else
            result_type.VTint = NTint;

        the_exp.Vunary_operation->sem_exp_type = result_type;
        break;
        
    default:
        fprintf(stderr, "typing: unknown expression type\n");
    }
}

