(* file: functionlang/oneprocess/Pascal/main.p *)

program all(input, output);

#include "onephasecompiler.h"
#include "onephasecompiler.i"
#include "sem.h"
#include "const.h"
#include "posPconverts.i"
#include "lexical.i"
#include "syntactic.i"
#include "resolve.i"
#include "typing.i"
#include "algorithm.i"

var ATfunction: Tfunction;
	thefunctions: functions;
	returntype: types;
	exptype: types;
	i: integer;

begin (* lexical and syntactic analysis *)
	InitLexer;
	Lexer; (* get initial token *)
	thefunctions := Parseprogram; (* create parse tree *)

	(* for each function, resolve parameter references *)
	for i := 1 to lengthSEQTfunction(thefunctions^.synfuncseq) do begin
		ATfunction:= ithinSEQTfunction(thefunctions^.synfuncseq, i);
		resolvereferences(ATfunction);
	end;

	(* for each function, add types to expressions and check for type *)
	(* conflict between function return value and body of function *)
	for i := 1 to lengthSEQTfunction(thefunctions^.synfuncseq) do begin
		ATfunction:= ithinSEQTfunction(thefunctions^.synfuncseq, i);
		expressiontype(ATfunction^.syndefinition);
		returntype:= ATfunction^.synreturntype;
		exptype:= ATfunction^.syndefinition^.semexptype;
		(* Check result type, permitting integers to be coerced into reals *)
		if (returntype^.Etypes = Ktypesint)
			and (exptype^.Etypes <> Ktypesint)
		then writeln('semantic: function ',
				StringTopacked(ATfunction^.synname^.lextoken),
				' returns incompatible type');
		end;

	(* perform constant folding on defining expression *)
	for i := 1 to lengthSEQTfunction(thefunctions^.synfuncseq) do begin
		ATfunction:= ithinSEQTfunction(thefunctions^.synfuncseq, i);
		fold(ATfunction^.syndefinition);
	end;
	
	(* output the parse tree of the equivalent function *)
	outputPort(output, thefunctions);
end.
