/* file: functionlang/oneprocess/C/main.c */

#include "onephasecompiler.h"
#include <stdio.h>
functions thesefunctions;

main()
{
	SEQfunction Sfunction;
	function Afunction;
	functions thefunctions;
	types return_type;
	types exp_type;

	if (yyparse()) {
		fprintf(stderr, "frontend: unrecoverable parsing error\n");
		exit(1);
	}
	else {

		/* for each function, resolve parameter references */

		foreachinSEQfunction(thesefunctions->syn_func_seq,
				Sfunction, Afunction) {
			resolve_references(Afunction);
		}

		/* for each function, add types to expressions and check for type */
		/* conflict between function return value and body of function */

		foreachinSEQfunction(thesefunctions->syn_func_seq,
				Sfunction, Afunction) {
			expression_type(Afunction->syn_definition);
			return_type = Afunction->syn_return_type;
			exp_type = Afunction->syn_definition.IDLclassCommon->sem_exp_type;

			/* Check result type, permitting integers to be coerced into reals */
			if ((typeof (return_type) == KTint)
					&& (typeof (exp_type) != KTint)) {
				fprintf (stderr,
					"semantic: function '%s' returns incompatible type\n",
					Afunction->syn_name->lex_token);
				}
			}

		/* perform constant folding on defining expression */
		foreachinSEQfunction(thesefunctions->syn_func_seq,
				Sfunction, Afunction) {
			fold(&(Afunction->syn_definition));
		}
	
		/* output the parse tree of the equivalent function */
		outputPort(stdout, thesefunctions, TWOPASS);
	
		exit(0);
	}
}
