(* file: functionlang/frontend/Pascal/syntactic.i *)

procedure feerror;
begin
	writeln(output, 'frontend: unrecoverable parsing error');
	halt;		
end;

procedure Next(desired: tokenType);
begin
	if token = desired
	then Lexer
	else feerror;
end;

function Parseexpression: expression; forward;

function Parsefactor: expression;
var tempunaryoperation: unaryoperation;
	tempformalparameterRef: formalparameterRef;
	tempunaryplus: unaryplus;
	tempunaryminus: unaryminus;
begin
	if token = UnaryPlusToken
	then begin
		Lexer;
		tempunaryoperation := Nunaryoperation;
		tempunaryplus := Nunaryplus;
		tempunaryoperation^.synop := tempunaryplus^.Punaryoperator;
		tempunaryoperation^.synargument := Parsefactor;
		Parsefactor := tempunaryoperation^.Poperation^.Pexpression;
		end
	else if token = UnaryMinusToken
	then begin
		Lexer;
		tempunaryoperation := Nunaryoperation;
		tempunaryminus := Nunaryminus;
		tempunaryoperation^.synop := tempunaryminus^.Punaryoperator;
		tempunaryoperation^.synargument := Parsefactor;
		Parsefactor := tempunaryoperation^.Poperation^.Pexpression;
		end
	else if token = IdentifierToken
	then begin
		tempformalparameterRef := NformalparameterRef;
		tempformalparameterRef^.synname := yylval.Videntifier;
		Parsefactor := tempformalparameterRef^.Pexpression;
		Lexer;
		end
	else if token = IntegerToken
	then begin
		Parsefactor := yylval.Vintegerconstant^.Pconstant^.Pexpression;
		Lexer;
		end
	else if token = RealToken
	then begin
		Parsefactor := yylval.Vrealconstant^.Pconstant^.Pexpression;
		Lexer;
		end
	else if token = LParenToken
	then begin
		Lexer;			(* go past left parenthesis *)
		Parsefactor := Parseexpression;
		if token <> RParenToken then feerror;
		Lexer;			(* go past right parenthesis *)
		end;
end;

function Parseterm: expression;
var leftfactor: expression;
	newbinary: binaryoperation;
	newtimes: times;
	newdivide: divide;
begin
	leftfactor := Parsefactor;
	while (token = TimesToken) or (token = DivideToken)
	do begin
		newbinary := Nbinaryoperation;
		newbinary^.synleft := leftfactor;
		if token = TimesToken
		then begin
			newtimes := Ntimes;
			newbinary^.synop := newtimes^.Pbinaryoperator;
			end
		else begin
			newdivide := Ndivide;
			newbinary^.synop := newdivide^.Pbinaryoperator;
			end;
		Lexer;			(* go past operator *)
		newbinary^.synright := Parsefactor;
		leftfactor := newbinary^.Poperation^.Pexpression
		end;
	Parseterm := leftfactor;
end;

function Parseexpression (* : expression *);
var leftterm: expression;
	newbinary: binaryoperation;
	tempplus: plus;
	tempminus: minus;
begin
	leftterm := Parseterm;
	while (token = PlusToken) or (token = MinusToken)
	do begin
		newbinary := Nbinaryoperation;
		newbinary^.synleft := leftterm;
		if token = PlusToken
		then begin
			tempplus := Nplus;
			newbinary^.synop := tempplus^.Pbinaryoperator;
			end
		else begin
			tempminus := Nminus;
			newbinary^.synop := tempminus^.Pbinaryoperator;
			end;
		Lexer;			(* go past operator *)
		newbinary^.synright := Parseterm;
		leftterm := newbinary^.Poperation^.Pexpression;
		end;
	Parseexpression := leftterm;
end;

function Parseparameters: SEQformalparameter;
var thisSEQfp: SEQformalparameter;
	thisfp: formalparameter;
	tempint: int;
	tempTreal: Treal;
begin
	initializeSEQformalparameter(thisSEQfp);
	if token = LParenToken
	then begin
		Lexer;
		while token = IdentifierToken do begin
			thisfp := Nformalparameter;
			appendrearSEQformalparameter(thisSEQfp, thisfp);
			with thisfp^ do begin
				synname := yylval.Videntifier;
				Lexer;
				Next(ColonToken);
				if token = integerKeyword
				then begin
					tempint := Nint;
					synparamtype := tempint^.Ptypes;
					end
				else if token = realKeyword
				then begin
					tempTreal := NTreal;
					synparamtype := tempTreal^.Ptypes;
					end
				else feerror;
				Lexer;
				if token = CommaToken
				then Lexer
				end
			end (* while *);
		Next(RParenToken);
		end;
	Parseparameters := thisSEQfp;
end;

function Parseprogram: functions;
var thesefunctions: functions;
	thisfunction: Tfunction;
	newint: int;
	newTreal: Treal;
begin
	thesefunctions := Nfunctions;
	initializeSEQTfunction(thesefunctions^.synfuncseq);
	while token = functionKeyword do begin
		thisfunction:= NTfunction;
		appendrearSEQTfunction(thesefunctions^.synfuncseq, thisfunction);
		with thisfunction^ do begin
			Lexer;
			if token <> IdentifierToken then feerror;
			synname := yylval.Videntifier;
			Lexer;
			synparameters := Parseparameters;
			Next(ColonToken);
			if token = integerKeyword
			then begin
				newint := Nint;
				synreturntype:= newint^.Ptypes;
				end
			else begin
				newTreal := NTreal;
				synreturntype:= newTreal^.Ptypes;
				end;
			Lexer;
			Next(EqualToken);
			syndefinition := Parseexpression;
			Next(SemiToken);
			end
		end (* while *);
	Parseprogram:= thesefunctions
end;
