(* file: functionlang/constantfold/Pascal/main.p *)

program constantfold (input, output);

#include "constant_fold.h"

var	ATfunction: Tfunction;
	thefunctions: functions;
	i: integer;
	ReaderOK: boolean;

#include "const2.h"
#include "constant_fold.i"

begin
	(* input the attributed syntax tree of a function *)
	thefunctions := inputport(input, ReaderOK);
	if not ReaderOK then halt;
	
	(* perform constant folding on defining expression *)
	for i := 1 to lengthSEQTfunction(thefunctions^.synfuncseq) do begin
		ATfunction:= ithinSEQTfunction(thefunctions^.synfuncseq, i);
		fold(ATfunction^.syndefinition);
	end;
	
	(* output the parse tree of the equivalent function *)
	outputport(output, thefunctions);
end.

