(* file: functionlang/constantfold/Pascal/algorithm.p *)

#include "constant_fold.h"
#include "const2.h"
#include "constant_fold.i"

function getconstantvalue (theconstant: constant): real;
begin
	if theconstant^.Econstant = Kconstantintegerconstant
	then getconstantvalue := theconstant^.Vintegerconstant^.lexvalue
	else getconstantvalue := theconstant^.Vrealconstant^.lexvalue;
end;

procedure fold (*var exp: expression*);
var	thebinaryoperation: binaryoperation;
	thebinaryoperator: binaryoperator;
	theunaryoperation: unaryoperation;
	theunaryoperator: unaryoperator;
	leftOperand: expression;
	rightOperand: expression;
	theOperand: expression;
	x, y, z: real;
	tempintegerconstant: integerconstant;
	tempint: int;
	temprealconstant: realconstant;
	tempTreal: Treal;

begin

	case exp^.Eexpression of
	KexpressionformalparameterRef: (* do nothing *);
	Kexpressionconstant: (* do nothing *);
	Kexpressionoperation: case exp^.Voperation^.Eoperation of
		Koperationbinaryoperation: begin
			fold (exp^.Voperation^.Vbinaryoperation^.synleft);
			fold (exp^.Voperation^.Vbinaryoperation^.synright);

			thebinaryoperation := exp^.Voperation^.Vbinaryoperation;
			thebinaryoperator := thebinaryoperation^.synop;
			leftOperand := thebinaryoperation^.synleft;
			rightOperand := thebinaryoperation^.synright;

			if (leftOperand^.Eexpression = Kexpressionconstant)
				and (rightOperand^.Eexpression = Kexpressionconstant)
			then begin
				x := getconstantvalue (leftOperand^.Vconstant);
				y := getconstantvalue (rightOperand^.Vconstant);

				case thebinaryoperator^.Ebinaryoperator of
				Kbinaryoperatorplus: z := (x + y);
				Kbinaryoperatorminus: z := (x - y);
				Kbinaryoperatordivide: z := (x / y);
				Kbinaryoperatortimes: z := (x * y);
				end;

				case thebinaryoperation^.Poperation^.Pexpression
						^.semexptype^.Etypes of
				Ktypesint: begin
					tempintegerconstant := Nintegerconstant;
					exp := tempintegerconstant^.Pconstant^.Pexpression;
					tempint := Nint;
					tempintegerconstant^.Pconstant^.Pexpression^.semexptype
						:= tempint^.Ptypes;
					tempintegerconstant^.lexvalue := trunc(z);
					end;
				KtypesTreal: begin
					temprealconstant := Nrealconstant;
					exp := temprealconstant^.Pconstant^.Pexpression;
					tempTreal := NTreal;
					temprealconstant^.Pconstant^.Pexpression^.semexptype
						:= tempTreal^.Ptypes;
					temprealconstant^.lexvalue := z;
					end;
				end
				end
			end;

		Koperationunaryoperation: begin
			fold (exp^.Voperation^.Vunaryoperation^.synargument);
			theunaryoperation := exp^.Voperation^.Vunaryoperation;
			theunaryoperator := theunaryoperation^.synop;
			theOperand := theunaryoperation^.synargument;
			if theOperand^.Eexpression = Kexpressionconstant
			then begin
				x := getconstantvalue (theOperand^.Vconstant);
				case theunaryoperator^.Eunaryoperator of
				Kunaryoperatorunaryplus: z := (  x);
				Kunaryoperatorunaryminus: z := (- x);
				end;

				case theunaryoperation^.Poperation^.Pexpression
						^.semexptype^.Etypes of
				Ktypesint: begin
					tempintegerconstant := Nintegerconstant;
					exp := tempintegerconstant^.Pconstant^.Pexpression;
					tempint := Nint;
					exp^.semexptype:= tempint^.Ptypes;
					tempintegerconstant^.lexvalue := trunc(z);
					end;
				KtypesTreal: begin
					temprealconstant := Nrealconstant;
					exp := temprealconstant^.Pconstant^.Pexpression;
					tempTreal := NTreal;
					exp^.semexptype:= tempTreal^.Ptypes;
					temprealconstant^.lexvalue := z;
					end;
				end	
				end;
			end
		end
	end
end;
