/* file: functionlang/constantfold/C/algorithm.c */

#include <stdio.h>
#include "constant_fold.h"

float get_constant_value (theConstant)
constant (theConstant);
{
	if (typeof (theConstant) == Kinteger_constant)
			return (theConstant.Vinteger_constant->lex_value);
	else return (theConstant.Vreal_constant->lex_value);
}

fold (exp)
expression* exp;
{
	binary_operation					theBinaryOperation;
	binaryoperator					theBinaryOperator;
	unary_operation					theUnaryOperation;
	unaryoperator					theUnaryOperator;
	expression					leftOperand;
	expression					rightOperand;
	expression					theOperand;
	float					x, y, z;

	switch (typeof (*exp)) {
	case Kbinary_operation:
		fold (&((*exp).Vbinary_operation->syn_left ));
		fold (&((*exp).Vbinary_operation->syn_right));

		theBinaryOperation = (*exp).Vbinary_operation;
		theBinaryOperator = theBinaryOperation->syn_op;
		leftOperand = theBinaryOperation->syn_left;
		rightOperand = theBinaryOperation->syn_right;

		if (((typeof (leftOperand ) == Kinteger_constant)
				||   (typeof (leftOperand ) == Kreal_constant))
			&&  ((typeof (rightOperand) == Kinteger_constant)
				||   (typeof (rightOperand) == Kreal_constant)))
		{
			x = get_constant_value (leftOperand);
			y = get_constant_value (rightOperand);

			switch (typeof (theBinaryOperator)) {
			case Kplus: z = (x + y); break;
			case Kminus: z = (x - y); break;
			case Kdivide: z = (x / y); break;
			case Ktimes: z = (x * y); break;
			}

			switch (typeof (theBinaryOperation->sem_exp_type)) {
			case KTint:
				(*exp).Vinteger_constant = Ninteger_constant;
				(*exp).Vinteger_constant->sem_exp_type.VTint = NTint;
				(*exp).Vinteger_constant->lex_value = z;
				break;

			case Kreal:
				(*exp).Vreal_constant = Nreal_constant;
				(*exp).Vreal_constant->sem_exp_type.Vreal = Nreal;
				(*exp).Vreal_constant->lex_value = z;
				break;
			}
		}

		break;

	case Kunary_operation:
		fold (&((*exp).Vunary_operation->syn_argument));

		theUnaryOperation = (*exp).Vunary_operation;
		theUnaryOperator = theUnaryOperation->syn_op;
		theOperand = theUnaryOperation->syn_argument;

		if ((typeof (theOperand ) == Kinteger_constant)
			||  (typeof (theOperand ) == Kreal_constant))
		{
			x = get_constant_value (theOperand);

			switch (typeof (theUnaryOperator)) {
			case Kunaryplus: z = (  x); break;
			case Kunaryminus: z = (- x); break;
			}

			switch (typeof (theUnaryOperation->sem_exp_type)) {
			case KTint:
				(*exp).Vinteger_constant = Ninteger_constant;
				(*exp).Vinteger_constant->sem_exp_type.VTint = NTint;
				(*exp).Vinteger_constant->lex_value = z;
				break;

			case Kreal:
				(*exp).Vreal_constant = Nreal_constant;
				(*exp).Vreal_constant->sem_exp_type.Vreal = Nreal;
				(*exp).Vreal_constant->lex_value = z;
				break;
			}
		}

		break;

	default:
		/* can only constant fold operations */
		break;
	}
}

