/* file: pipes.c */
/* Example program to configure a compiler of four phases:
	preprocessor, parser, semantic analysis, and code
	generation, using pipes to communicate error instances.
*/
#include <stdio.h>
#include <errno.h>
#include <sys/wait.h>

/* location of the code for the phases */
#define CPP	"/lib/cpp"
#define PARSE	"/usr/softlab/lib/parse"
#define SEM	"/usr/softlab/lib/sa"
#define CG	"/usr/softlab/lib/cg"
#define L	"/usr/softlab/bin/lister"

newpipe (fildes)	/* create a pipe */
int fildes[];
{
	if (pipe(fildes) == -1) {
	    fprintf(stderr, "pipe not created\n");
	    exit(1);
	}
}

closepipes ()		/* close all pipes not needed */
{
	close(fildes1[0]);
	close(fildes1[1]);
	close(fildes2[0]);
	close(fildes2[1]);
	close(fildes3[0]);
	close(fildes3[1]);
	close(efildes2[0]);
	close(efildes2[1]);
	close(efildes3[0]);
	close(efildes3[1]);
	close(efildes4[0]);
	close(efildes4[1]);
}

main(argc, argv)
int argc;
char *argv[];
{
	int fildes1[2];	    /* file descriptors for pipe call */
	int fildes2[2];	    /* file descriptors for pipe call */
	int fildes3[2];	    /* file descriptors for pipe call */
	int fildes4[2];	    /* file descriptors for pipe call */
	int efildes2[2];    /* file descriptors for stderr */
	int efildes3[2];    /* file descriptors for stderr */
	int efildes4[2];    /* file descriptors for stderr */
	int pid;	    /* process id returned from fork call */
	int pid2;	    /* process id returned from fork call */
	int pid3;	    /* process id returned from fork call */
	int pid4;	    /* process id returned from fork call */
	char par1[10];
	char par2[10];
	char par3[10];	    /* parameters to lister */

	if (argc != 2) {
	    fprintf(stderr, "usage: %s idlfile\n", argv[0]);
	    exit(1);
	}

/* Create the pipes */
	newpipe(fildes1);
	newpipe(fildes2);
	newpipe(fildes3);
	newpipe(fildes4);
	newpipe(efildes2);
	newpipe(efildes3);
	newpipe(efildes4);
	if ((pid = fork()) == -1) {
	    fprintf(stderr, "fork call failed\n");
	    exit(2);
	}

	if ( pid != 0) {  /* parent process */
	    pid2 = fork();
	    if (pid2 != 0) {  /* parent */
		pid3 = fork();
		if (pid3 != 0) {  /* parent */
		    pid4 = fork();
		    if (pid4 != 0) { /* parent */
/* the lister */
			dup2(efildes2[0], );
			dup2(efildes3[0], );
			dup2(efildes4[0], );
			closepipes().;
			sprintf(par1, "-e%d", efildes2[0]);
			sprintf(par2, "-e%d", efildes3[0]);
			sprintf(par3, "-e%d", efildes4[0]);
			execl(L, L, par1, par2, par3, 0);
		    }
		    else { /* child */
/* the code generator */
			dup2(fildes3[0], 0); /* make stdin of cg stdout of sa*/
			dup2(efildes4[1], 2); /* make stderr of cg to err fd 4*/
			closepipes();
			execl(CG, CG, 0);
		    }
		}
		else {	/* child */
/* the semantic analyzer */
		    dup2(fildes2[0], 0);   /*make stdin of sa stdout of parse */
		    dup2(fildes3[1], 1); /* make stdout of sa stdin of cg */
		    dup2(efildes3[1], 2); /* make stderr of sa to err fd 3*/
		    closepipes();
		    execl(SEM, SEM, "-", 0);
		}
	    }
	    else {  /* child */
/* the parser */
		dup2(fildes1[0], 0);   /* make stdin of parse stdout of cpp */
		dup2(fildes2[1], 1); /* make stdout of parse stdin of sa */
		dup2(efildes2[1], 2); /* make stderr of parse to err fd 2*/
		closepipes();
		execl(PARSE, PARSE, 0);
	    }
	}
	else { /* child process */
/* the preprocessor */
	    dup2(fildes1[1], 1); 	/* make stdout of cpp stdin of parse */
	    closepipes();
	    execl(CPP, CPP, argv[1], 0); /* pass the source file to the C
					    preprocessor */
	}

}
