/****************************************************************/
/* file: pos.c                                                  */
/*       contains the conversion routines for the private type  */
/*       source_position, which has two representations: pos    */
/*       and integer.                                           */
/*                                                              */
/* source_position is encoded as an integer (32 bits) as follows*/
/*     16 bits for character offset in source file              */
/*      9 bits for the character offset from the beginning of   */
/*                 the line                                     */
/*      7 bits for line number in the source file               */
/*                                                              */
/****************************************************************/

# include "pos.h"

pos intTopos(theint)
     int theint;
{
  pos thepos;
  
  thepos = Npos;
  
  thepos->charoffset = (theint >> 16) & 0xFFFF;
  thepos->lineoffset = (theint >>  7) & 0x01FF;
  thepos->linenumber = (theint      ) & 0x007F;
  
  return (thepos);
}

int posToint(thepos)
     pos thepos;
{
  return (((thepos->charoffset & 0xFFFF) << 16) |
	  ((thepos->lineoffset & 0x01FF) <<  7) |
	  ((thepos->linenumber & 0x007F)));
}
