/* file: semantic/C/typing.c */

#include "semantic.h"
#include <stdio.h>

/* the procedure for expression typing */

expression_type (the_exp)
expression	the_exp;
{
    expression left_exp;  /* for de-referencing left exp of binary op */
    expression right_exp; /* for de-referencing right exp of binary op */
    expression arg_exp;   /* for de-referencing argument of unary op */
    types left_type;
    types right_type;
    types arg_type;
    types result_type;
    
    switch (typeof(the_exp)) {
    case Kinteger_constant:
        the_exp.Vinteger_constant->sem_exp_type.VTint = NTint;
        break;
        
    case Kreal_constant:
        the_exp.Vreal_constant->sem_exp_type.Vreal = Nreal;
        break;

    case Kboolean_constant:
        the_exp.Vboolean_constant->sem_exp_type.Vboolean = Nboolean;
        break;
        
    case Kformal_parameterRef:
        the_exp.Vformal_parameterRef->sem_exp_type =
            the_exp.Vformal_parameterRef->sem_entity->syn_param_type;
        break;
        
    case Kbinary_operation:
        left_exp = the_exp.Vbinary_operation->syn_left;
        right_exp = the_exp.Vbinary_operation->syn_right;
        expression_type(left_exp);
        expression_type(right_exp);
	left_type = left_exp.IDLclassCommon->sem_exp_type;
	right_type = right_exp.IDLclassCommon->sem_exp_type;

	switch (typeof (the_exp.Vbinary_operation->syn_op))
	{
	case Kbooleanor:
	case Kbooleanand:
		if ((typeof (left_type) != Kboolean) || (typeof (right_type) != Kboolean))
		{
			fprintf (stderr,
			"args to boolean and/or must both be booleans\n");
		}
		result_type.Vboolean = Nboolean;
		break;

	case Kequal:
	case Knotequal:
		if (((typeof (left_type) == Kboolean) && (typeof (right_type) != Kboolean))
		||  ((typeof (left_type) != Kboolean) && (typeof (right_type) == Kboolean)))
		{
			fprintf (stderr,
			"args to equal/notequal must both be booleans %s",
			"or both be numeric\n");
		}
		result_type.Vboolean = Nboolean;
		break;

	case Klessthan:
	case Klessthanorequal:
	case Kgreaterthan:
	case Kgreaterthanorequal:
		if (((typeof (left_type)  != KTint) && (typeof (left_type)  != Kreal))
		||  ((typeof (right_type) != KTint) && (typeof (right_type) != Kreal)))
		{
			fprintf (stderr,
			"args to relational ops must both be numeric\n");
		}
		result_type.Vboolean = Nboolean;
		break;

	case Kplus:
	case Kminus:
	case Ktimes:
		if (((typeof (left_type)  != KTint) && (typeof (left_type)  != Kreal))
		||  ((typeof (right_type) != KTint) && (typeof (right_type) != Kreal)))
		{
			fprintf (stderr,
			"args to arithmetic ops must both be numeric\n");
		}
		if ((typeof (left_type) != KTint) || (typeof (right_type) != KTint))
			result_type.Vreal = Nreal;
		else
			result_type.VTint = NTint;
		break;

	case Kdivide:
		if (((typeof (left_type)  != KTint) && (typeof (left_type)  != Kreal))
		||  ((typeof (right_type) != KTint) && (typeof (right_type) != Kreal)))
		{
			fprintf (stderr,
			"args to arithmetic ops must both be numeric\n");
		}
		result_type.Vreal = Nreal;
		break;

	default:
		fprintf (stderr,
			"typing: unknown binary operator\n");
		break;
	}
        the_exp.Vunary_operation->sem_exp_type = result_type;
        break;
        
    case Kunary_operation:
        arg_exp = the_exp.Vunary_operation->syn_argument;
        expression_type(arg_exp);
	arg_type = arg_exp.IDLclassCommon->sem_exp_type;

	switch (typeof (the_exp.Vunary_operation->syn_op))
	{
	case Kbooleannot:
		if (typeof (arg_type) != Kboolean)
		{
			fprintf (stderr,
			"arg to boolean not must be boolean\n");
		}
		result_type.Vboolean = Nboolean;
		break;

	case Kunaryplus:
	case Kunaryminus:
		if ((typeof (arg_type)  != KTint) && (typeof (arg_type)  != Kreal))
		{
			fprintf (stderr,
			"arg to unary arithmetic op must be numeric\n");
		}
		if (typeof (arg_type) != KTint)
			result_type.Vreal = Nreal;
		else
			result_type.VTint = NTint;
		break;

	default:
		fprintf (stderr,
			"typing: unknown unary operator\n");
		break;
	}
        the_exp.Vunary_operation->sem_exp_type = result_type;
        break;
        
    default:
        fprintf(stderr,
		"typing: unknown expression type\n");
    }
}

