/* file: semantic/C/resolve.c */

#include "semantic.h"
#include <stdio.h>

/* the procedure for resolving parameter references */

resolve_references(thefunction)
function thefunction;
{
    resolve_exp(thefunction->syn_definition, thefunction->syn_parameters);
}

resolve_exp(the_exp, theparameters)
expression the_exp;
SEQformal_parameter theparameters;
{
    SEQformal_parameter Sp;
    formal_parameter Aformal_parameter;
    
    switch (typeof(the_exp)) {
    case Kinteger_constant:
        break;
        
    case Kreal_constant:
        break;
        
    case Kboolean_constant:
        break;
        
    case Kformal_parameterRef:
        foreachinSEQformal_parameter(theparameters, Sp, Aformal_parameter) {
            if (Aformal_parameter->syn_name->lex_token
                    == the_exp.Vformal_parameterRef->syn_name->lex_token) {
                the_exp.Vformal_parameterRef->sem_entity = Aformal_parameter;
                break;
            }
        };
        break;
        
    case Kbinary_operation:
        resolve_exp(the_exp.Vbinary_operation->syn_left, theparameters);
        resolve_exp(the_exp.Vbinary_operation->syn_right, theparameters);
        break;
        
    case Kunary_operation:
        resolve_exp(the_exp.Vunary_operation->syn_argument, theparameters);
        break;
        
    default:
        fprintf(stderr, "resolve: invalid type in switch\n");
    }
}

