/* file: semantic/C/main.c */

#include "semantic.h"
#include <stdio.h>

/* the main driver for the expression typing program */
main()
{
    SEQfunction Sfunction;
    function Afunction;
    functions thefunctions;
    types return_type;
    types exp_type;

    /* read in the input data structure */

    thefunctions = input(stdin);

    /* for each function, resolve parameter references */

    foreachinSEQfunction
	(thefunctions->syn_func_seq, Sfunction, Afunction) {
        resolve_references(Afunction);
    }

    /* for each function, add types to expressions and check for type
     * conflict between function return value and body of function */

    foreachinSEQfunction
	(thefunctions->syn_func_seq, Sfunction, Afunction) {

        expression_type(Afunction->syn_definition);
	return_type = Afunction->syn_return_type;
	exp_type = Afunction->syn_definition.IDLclassCommon->sem_exp_type;

	switch (typeof (return_type))
	{
	case KTint:
		if (typeof (exp_type) != KTint)
		{
			fprintf (stderr,
			"semantic: function '%s' returns incompatible type\n",
			Afunction->syn_name->lex_token);
		}
		break;

	case Kreal:
		if ((typeof (exp_type) != KTint)
		&&  (typeof (exp_type) != Kreal))
		{
			fprintf (stderr,
			"semantic: function '%s' returns incompatible type\n",
			Afunction->syn_name->lex_token);
		}
		break;


	case Kboolean:
		if (typeof (exp_type) != Kboolean)
		{
			fprintf (stderr,
			"semantic: function '%s' returns incompatible type\n",
			Afunction->syn_name->lex_token);
		}
		break;


	default:
		fprintf (stderr,
			"semantic: function '%s' returns unknown type\n",
			Afunction->syn_name->lex_token);
	}
    }

    /* write out the attributed data structure */

    output(stdout, thefunctions, TWOPASS);
    exit(0);
}

