%{/* file: frontend/C/main.y */
#include "parser.h"
#include <stdio.h>
functions thesefunctions;
%}

/* types associated with grammar symbols */
%union{
function Vfunction;
identifier Videntifier;
integer_constant Vinteger_constant;
real_constant Vreal_constant;
boolean_constant Vboolean_constant;
SEQformal_parameter Vparameters;
formal_parameter Vformal_parameter;
expression Vexpression;
types Vtypes;
}

/* token declarations */
%token <Videntifier> IdentifierToken 1
%token <Vinteger_constant> IntegerToken 2
%token <Vreal_constant> RealToken 3
%token <Vboolean_constant> BooleanToken 31
/* keywords */
%token functionKeyword 4
%token integerKeyword 5
%token realKeyword 6
%token booleanKeyword 61
/* punctuation */
%token PlusToken 7
%token MinusToken 8
%token TimesToken 9
%token DivideToken 10
%token LParenToken 11
%token RParenToken 12
%token SemiToken 13
%token EqualToken 14
%token ColonToken 15
%token CommaToken 16
%token OrToken 17
%token AndToken 18
%token NotToken 19
%token NotEqualToken 20
%token LessThanToken 21
%token LessThanOrEqualToken 22
%token GreaterThanToken 23
%token GreaterThanOrEqual Token 24

/* precedence */
%left OrToken
%left AndToken
%left NotToken
%nonassoc EqualToken NotEqualToken LessThanToken LessThanOrEqualToken GreaterThanToken GreaterThanOrEqualToken
%left PlusToken MinusToken
%left TimesToken DivideToken
%left UMINUS

%type <Vfunction> _function
%type <Vparameters> _parameters
%type <Vparameters> _parameters_list
%type <Vformal_parameter> _parameter
%type <Vexpression> _expression
%type <Vtypes> _type

%%

_program :	/* empty */
	{
		thesefunctions = Nfunctions;
		initializeSEQfunction(thesefunctions->syn_func_seq);
	}
	|	_program _function
	{
		appendrearSEQfunction(thesefunctions->syn_func_seq, $2);
	}
	;

_function :	functionKeyword IdentifierToken _parameters
		ColonToken _type EqualToken _expression SemiToken
	{
		function thisfunction;
		thisfunction = Nfunction;
		thisfunction->syn_name = $2;
		thisfunction->syn_parameters = $3;
		thisfunction->syn_return_type = $5;
		thisfunction->syn_definition = $7;
		$$ = thisfunction;
	}
	;

_parameters :	/* empty */
	{
		SEQformal_parameter this;
		initializeSEQformal_parameter(this);
		$$ = this;
	}
	|	LParenToken _parameters_list RParenToken
	{
		$$ = $2;
	}
	;

_parameters_list : _parameter
	{
		SEQformal_parameter this;
		initializeSEQformal_parameter(this);
		appendrearSEQformal_parameter(this, $1);
		$$ = this;
	}
	|	_parameters_list CommaToken _parameters
	{
		appendrearSEQformal_parameter($1, $3);
		$$ = $1;
	}
	;

_parameter :	IdentifierToken ColonToken _type
	{
		formal_parameter this;
		this = Nformal_parameter;
		this->syn_name = $1;
		this->syn_param_type = $3;
		$$ = this;
	}
	;

_type :		integerKeyword
	{
		$$.VTint = NTint;
	}
	|	realKeyword
	{
		$$.Vreal = Nreal;
	}
	|	booleanKeyword
	{
		$$.Vboolean = Nboolean;
	}
	;

_expression :	IntegerToken
	{	
		$$.Vinteger_constant = $1;
	}
	|	RealToken
	{	
		$$.Vreal_constant = $1;
	}
	|	BooleanToken
	{	
		$$.Vboolean_constant = $1;
	}
	|	IdentifierToken
	{	
		formal_parameterRef p;
		p = Nformal_parameterRef;
		p->syn_name = $1;
		$$.Vformal_parameterRef = p;
	}
	|	_expression OrToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vbooleanor = Nbooleanor;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression AndToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vbooleanand = Nbooleanand;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	NotToken _expression
	{	
		unary_operation u;
		u = Nunary_operation;
		u->syn_argument = $2;
		u->syn_op.Vbooleannot = Nbooleannot;
		$$.Vunary_operation = u;
	}
	|	_expression EqualToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vequal = Nequal;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression NotEqualToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vnotequal = Nnotequal;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression LessThanToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vlessthan = Nlessthan;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression LessThanOrEqualToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vlessthanorequal = Nlessthanorequal;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression GreaterThanToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vgreaterthan = Ngreaterthan;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression GreaterThanOrEqualToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vgreaterthanorequal = Ngreaterthanorequal;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression PlusToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vplus = Nplus;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression MinusToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vminus = Nminus;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression TimesToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vtimes = Ntimes;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	_expression DivideToken _expression
	{	
		binary_operation b;
		b = Nbinary_operation;
		b->syn_left = $1;
		b->syn_op.Vdivide = Ndivide;
		b->syn_right = $3;
		$$.Vbinary_operation = b;
	}
	|	PlusToken _expression %prec UMINUS
	{	
		unary_operation u;
		u = Nunary_operation;
		u->syn_argument = $2;
		u->syn_op.Vunaryplus = Nunaryplus;
		$$.Vunary_operation = u;
	}
	|	MinusToken _expression %prec UMINUS
	{	
		unary_operation u;
		u = Nunary_operation;
		u->syn_argument = $2;
		u->syn_op.Vunaryminus = Nunaryminus;
		$$.Vunary_operation = u;
	}
	|	LParenToken _expression RParenToken
	{
		$$ = $2;
	}
	;
%%

main()
{	
    if (yyparse()) {
	fprintf(stderr, "frontend: unrecoverable parsing error\n");
	exit(1);
    }
    else {
	ParseTreeOut(stdout,thesefunctions);
	exit(0);
    }
}

yyerror(s)
char *s;
{
    fprintf(stderr, "frontend: %s\n",s);
    exit(1);
}

yywrap()
{
    return (1);
}
