%{/* file: frontend/C/lex.l */
#include "parser.h"
#include "tokens.h"

int linecount = 1,
    charoffset = 0,
    linestart = 0; /* character offset of first character of this line */
%}

%%
"+"		{ charoffset+=1;return (PlusToken);	}
"-"		{ charoffset+=1;return (MinusToken);	}
"*"		{ charoffset+=1;return (TimesToken);	}
"/"		{ charoffset+=1;return (DivideToken);	}
"("		{ charoffset+=1;return (LParenToken);	}
")"		{ charoffset+=1;return (RParenToken);	}
";"		{ charoffset+=1;return (SemiToken);	}
"="		{ charoffset+=1;return (EqualToken);	}
":"		{ charoffset+=1;return (ColonToken);	}
","		{ charoffset+=1;return (CommaToken);	}
"~="		{ charoffset+=2;return (NotEqualToken);	}
"<"		{ charoffset+=1;return (LessThanToken);	}
"<="		{ charoffset+=2;return (LessThanOrEqualToken);		}
">"		{ charoffset+=1;return (GreaterThanToken);		}
">="		{ charoffset+=2;return (GreaterThanOrEqualToken);	}
[0-9]+		{ 
		  int this;
		  charoffset += yyleng;
		  sscanf(yytext,"%d",&this);
		  yylval.Vinteger_constant = Ninteger_constant;
		  yylval.Vinteger_constant->lex_value = this;
		  return (IntegerToken);
		}
[0-9]+"."[0-9]*	{
		  float this;
		  charoffset += yyleng;
		  sscanf(yytext,"%f",&this);
		  yylval.Vreal_constant = Nreal_constant;
		  yylval.Vreal_constant->lex_value = this;
		  return (RealToken);
		}
[a-zA-Z][a-zA-Z0-9_]* {
		  if (strcmp(yytext,"function")==0) {
			charoffset += yyleng;
			return (functionKeyword);
		  }
		  else if (strcmp(yytext,"integer")==0) {
			charoffset += yyleng;
			return (integerKeyword);
		  }
		  else if (strcmp(yytext,"real")==0) {
			charoffset += yyleng;
			return (realKeyword);
		  }
		  else if (strcmp(yytext,"boolean")==0) {
			charoffset += yyleng;
			return (booleanKeyword);
		  }
		  else if (strcmp(yytext,"true")==0) {
			charoffset += yyleng;
			yylval.Vboolean_constant = Nboolean_constant;
			yylval.Vboolean_constant->lex_value = TRUE;
			return (BooleanToken);
		  }
		  else if (strcmp(yytext,"false")==0) {
			charoffset += yyleng;
			yylval.Vboolean_constant = Nboolean_constant;
			yylval.Vboolean_constant->lex_value = FALSE;
			return (BooleanToken);
		  }
		  else if (strcmp(yytext,"or")==0) {
			charoffset += yyleng;
			return (OrToken);
		  }
		  else if (strcmp(yytext,"and")==0) {
			charoffset += yyleng;
			return (AndToken);
		  }
		  else if (strcmp(yytext,"not")==0) {
			charoffset += yyleng;
			return (NotToken);
		  }
		  else {
			identifier n;
			n = Nidentifier;
			n->lex_token = NewString(yytext);
			n->lex_pos = Npos;
			n->lex_pos->charoffset = charoffset;
			n->lex_pos->lineoffset = charoffset - linestart;
			n->lex_pos->linenumber = linecount;
			yylval.Videntifier = n;
			charoffset += yyleng;
			return (IdentifierToken);
		  }
		}
[ \t]*		{
		  /* white space */
		  charoffset+=yyleng;
		}
\n		{
		  /* more white space */
		  linecount += 1;
		  charoffset += 1;
		  linestart = charoffset;
		}
%%
