(* file: billing/Pascal/algorithm.p *)
program main;
#include "billing.h"
#include "billingMacros.h"
var
	thisCL: customerlist;
	thisTL: transactionlist;
	thisBL: billlist;
	thisCustomer, foundCustomer: Customer;
	thisTransaction: Transaction;
	thisbill: bill;
	CustomerSeq: SEQCustomer;
	TransactionSeq: SEQTransaction;
	cIn, tIn, cOut, bOut: text;
	i, j: integer;
	readerOK: boolean;
#include "billing.i"
begin	
(* input the initial customer list *)
	reset(cIn, 'customers.in');
	thisCL := customersin(cIn, readerOK);
	if not readerOK then halt;
(* input the transactions list *)
	reset(tIn, 'transactions.in');
	thisTL := transactionsin(tIn, readerOK);
	if not readerOK then halt;
(* initialize bills *)
	thisBL := Nbilllist;
	initializeSEQbill(listOfbilllist(thisBL));
(* process the transactions *)
	TransactionSeq := listOftransactionlist(thisTL);
	for i := 1 to lengthSEQTransaction(TransactionSeq) do begin
		thisTransaction := ithinSEQTransaction(TransactionSeq, i);
		CustomerSeq := listOfcustomerlist(thisCL);
			(* find the Customer mentioned in the transaction *)
		foundCustomer := nil;
		for j := 1 to lengthSEQCustomer(CustomerSeq) do begin
			thisCustomer := ithinSEQCustomer(CustomerSeq, i);
			if customernumberOfCustomer(thisCustomer)
				= customernumberOfTransaction(thisTransaction)
			then foundCustomer := thisCustomer
			end;
		case thisTransaction^.ETransaction of
		KTransactioncredit: (* credit the Customer *)
			balanceOfCustomer(thisCustomer) := balanceOfCustomer(thisCustomer)
					+ amountOfTransaction(thisTransaction);
		KTransactiondebit: begin (* generate a bill *)
			thisbill := Nbill;
			billeeOfbill(thisbill) := thisCustomer;
			amountOfbill(thisbill) := amountOfTransaction(thisTransaction);
			appendrearSEQbill(listOfbilllist(thisBL), thisbill);
			end
		end;
	end;		(* of iteration over transactions *)
(* write out the updated customer list *)
	rewrite(cOut, 'customers.out');
	customersout(cOut, thisCL);
(* write out the list of bills *)
	rewrite(bOut, 'bills.out');
	billsout(bOut, thisBL);
end.

