/* file: billing/C/algorithm.c */
#include <stdio.h>
#include "billing.h"
#include "billingMacros.h"

main ()
{
	customer_list					thisCL;
	transaction_list					thisTL;
	bill_list					thisBL;
	Customer					thisCustomer;
	Transaction					thisTransaction;
	bill					thisbill;
	SEQCustomer					remainingCustomers;
	SEQTransaction					remainingTransactions;
	FILE					*c_in, *t_in, *c_out, *b_out;
	IDLForceLabels = TRUE; /* to force all nodes to have labels */
/* input the initial customer list */
	c_in = fopen("customers.in", "r");
	thisCL = customers_in(c_in);
/* input the transactions list */
	t_in = fopen("transactions.in", "r");
	thisTL = transactions_in(t_in);
/* initialize bills */
	thisBL = Nbill_list;
	initializeSEQbill(listOfbill_list(thisBL));

/* process the transactions */
	foreachinSEQTransaction(listOftransaction_list(thisTL),
							remainingTransactions, thisTransaction) {
			/* find the Customer mentioned in the transaction */
		foreachinSEQCustomer(listOfcustomer_list(thisCL),
							 remainingCustomers, thisCustomer)
			if (customer_numberOfCustomer(thisCustomer)
				== customer_numberOfTransaction(thisTransaction)) break;
		switch (typeof(thisTransaction)) {
		case Kcredit:				/* credit the Customer */
			balanceOfCustomer(thisCustomer)
				+= amountOfTransaction(thisTransaction);
			break;
		case Kdebit:				/* generate a bill */
			thisbill = Nbill;
			billeeOfbill(thisbill) = thisCustomer;
			amountOfbill(thisbill) = amountOfTransaction(thisTransaction);
			appendrearSEQbill(listOfbill_list(thisBL), thisbill);
			break;
		/* can't be anything else */
		}
	}
	
/* write out the updated customer list */
	c_out = fopen("customers.out", "w");
	customers_out(c_out, thisCL);
/* write out the list of bills */
	b_out = fopen("bills.out", "w");
	bills_out(b_out, thisBL);
	exit(0);
}
