#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "msql.h"


#define SELECT_QUERY "select name from test where num = %d"


int main(argc,argv)
	int	argc;
	char	*argv[];
{
	int	count,
		sock,
		num;
	char	qbuf[160];
	
	if (argc != 3)
	{
		printf("usage : select_test <dbname> <num>\n\n");
		exit(1);
	}

	if ((sock = msqlConnect(NULL)) < 0)
	{
		printf("Couldn't connect to engine!\n%s\n\n", msqlErrMsg);
		perror("");
		exit(1);
	}

	if (msqlSelectDB(sock,argv[1]) < 0)
	{
		printf("Couldn't select database %s!\n%s\n",argv[1],msqlErrMsg);
	}

	count = 0;
	num = atoi(argv[2]);
	while (count < num)
	{
		sprintf(qbuf,SELECT_QUERY,count);
		if(msqlQuery(sock,qbuf) < 0)
		{
			printf("Query failed (%s)\n",msqlErrMsg);
			printf("Selected %d rows\n",count);
			exit(1);
		}
		count++;
	}
	msqlClose(sock);
	exit(0);
}
