#ifndef ABSOLUTE_H
#define ABSOLUTE_H
/*
**	An absolute date is a an integer representing the number of days
**	since 12/1/1 BC, i.e., day 1 is 1/1/1 AD.
**
**	The functions below manipulate absolute dates.
**
**	This work is derived from GNU software, so you should read
**	the GNU license agreement if you are plannning to use
**	them in commercial software.
*/

typedef int ABSOLUTE_DAY;

extern ABSOLUTE_DAY gregorian_to_absolute __ANSI_PROTO((int, int , int));
extern ABSOLUTE_DAY current_absolute_date __ANSI_PROTO((void));

extern int absolute_to_gregorian_day __ANSI_PROTO((ABSOLUTE_DAY));
extern int absolute_to_gregorian_month __ANSI_PROTO((ABSOLUTE_DAY));
extern int absolute_to_gregorian_year __ANSI_PROTO((ABSOLUTE_DAY));

extern WEEKDAY absolute_to_weekday __ANSI_PROTO((ABSOLUTE_DAY));

#endif /* ABSOLUTE_H */
