/*
**	msqladmin.c	- 
**
**
** Copyright (c) 1993-95  David J. Hughes
** Copyright (c) 1995  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/


#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef HAVE_DIRENT
#  include <dirent.h>
#else
#  include <sys/dir.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "common/portability.h"

#ifdef HAVE_SYS_UN_H
#  include <sys/un.h>
#endif


#include "common/site.h"

#include "version.h"
#include "msql.h"
#include "msql_priv.h"


#include <common/site.h>
#include <common/portability.h>

int	qFlag = 0;


void usage()
{
	printf("\n\nusage : msqladmin [-h host] [-f conf] [-q] <Command>\n\n");
	printf("where command =");
	printf("\t drop DatabaseName\n");
	printf("\t\t create DatabaseName\n");
	printf("\t\t shutdown\n");
	printf("\t\t reload\n");
	printf("\t\t version\n");
	printf("\t\t stats\n");
	printf("\n -q\tQuiet mode.  No verification of commands.\n\n");
}


void createDB(sock,db)
	int	sock;
	char	*db;
{
	if(msqlCreateDB(sock,db) < 0)
	{
		fprintf(stderr,"\nmSQL Command failed!\nServer error = %s\n\n",
				msqlErrMsg);
		msqlClose(sock);
		exit(1);
	}
	else
	{
		printf("Database \"%s\" created.\n",db);
	}
}


void dropDB(sock,db)
	int	sock;
	char	*db;
{
	char	buf[10];


	if (!qFlag)
	{
		printf("\n\nDropping the database is potentially a very bad ");
		printf("thing to do.\nAny data stored in the database will be");
		printf(" destroyed.\n\nDo you really want to drop the ");
		printf("\"%s\" ",db);
		printf("database?  [Y/N] ");
		fflush(stdout);
		bzero(buf,10);
		fgets(buf,10,stdin);
		if ( (*buf != 'y') && (*buf != 'Y'))
		{
			printf("\n\nOK, aborting database drop!\n\n");
			msqlClose(sock);
			exit(0);
		}
	}
	if(msqlDropDB(sock,db) < 0)
	{
		fprintf(stderr,"\nmSQL Command failed!\nServer error = %s\n\n",
			msqlErrMsg);
		msqlClose(sock);
		exit(1);
	}
	else
	{
		fprintf(stderr,"Database \"%s\" dropped\n",db);
	}
}



void main(argc,argv)
	int	argc;
	char	*argv[];
{
	int	sock,
		c,
		argsLeft,
		errFlag = 0;
	char	*host = NULL,
		*confFile = NULL;
	extern	int optind;
	extern	char *optarg;


	while((c=getopt(argc,argv,"f:h:q"))!= -1)
        {
                switch(c)
                {
                        case 'h':
                                if (host)
                                        errFlag++;
                                else
                                        host = optarg;
                                break;
                        case 'f':
                                if (confFile)
                                        errFlag++;
                                else
                                        confFile = optarg;
                                break;
			case 'q':
				if (qFlag)
					errFlag++;
				else
					qFlag++;
				break;
			case '?':
				errFlag++;
				break;
		}
	}

	argsLeft = argc - optind;

	if (errFlag || argsLeft == 0)
	{
		usage();
		exit(1);
	}

	msqlLoadConfigFile(confFile);

        if ((sock = msqlConnect(host)) < 0)
        {
                fprintf(stderr,"ERROR : %s\n",msqlErrMsg);
                exit(1);
        }

	if (strcmp(argv[optind],"create") == 0)
	{
		if (argsLeft != 2)
		{
			usage();
			msqlClose(sock);
			exit(1);
		}
		createDB(sock,argv[optind+1]);
		msqlClose(sock);
		exit(0);
	}
	if (strcmp(argv[optind],"drop") == 0)
	{
		if (argsLeft != 2)
		{
			usage();
			msqlClose(sock);
			exit(1);
		}
		dropDB(sock,argv[optind+1]);
		msqlClose(sock);
		exit(0);
	}
	if (strcmp(argv[optind],"shutdown") == 0)
	{
		if (argsLeft != 1)
		{
			usage();
			msqlClose(sock);
			exit(1);
		}
		if(msqlShutdown(sock) < 0)
		{
			printf("\nmSQL Command failed!\nServer error = %s\n\n",
				msqlErrMsg);
			msqlClose(sock);
			exit(1);
		}
		exit(0);
	}
	if (strcmp(argv[optind],"reload") == 0)
	{
		if (argsLeft != 1)
		{
			usage();
			msqlClose(sock);
			exit(1);
		}
		if(msqlReloadAcls(sock) < 0)
		{
			printf("\nmSQL Command failed!\nServer error = %s\n\n",
				msqlErrMsg);
			msqlClose(sock);
			exit(1);
		}
		msqlClose(sock);
		exit(0);
	}
	if (strcmp(argv[optind],"version") == 0)
	{
		if (argsLeft != 1)
		{
			usage();
			msqlClose(sock);
			exit(1);
		}
		printf("\nVersion Details :-\n\n");
		printf("\tmsqladmin version \t%s\n",SERVER_VERSION);
		printf("\tmSQL server version \t%s\n", msqlGetServerInfo());
		printf("\tmSQL protocol version \t%d\n", msqlGetProtoInfo());
		printf("\tmSQL connection \t%s\n",msqlGetHostInfo());
		printf("\tTarget platform \t%s\n\n",TARGET);

		printf("Configuration Details :-\n\n");
		printf("\tDefault config file\t%s/msql.conf\n",INST_DIR);
		printf("\tTCP socket         \t%d\n", 
			msqlGetIntConf("tcp_port"));
		printf("\tUNIX socket        \t%s\n", 
			(char *)msqlGetCharConf("unix_port"));
		printf("\tmSQL user         \t%s\n", 
			(char *)msqlGetCharConf("msql_user"));
		printf("\tAdmin user         \t%s\n", 
			(char *)msqlGetCharConf("admin_user"));
		printf("\tInstall directory  \t%s\n",
			(char *)msqlGetCharConf("inst_dir"));
		printf("\tPID file location  \t%s\n",
			(char *)msqlGetCharConf("pid_file"));
		printf("\n\n");
		msqlClose(sock);
		exit(0);
	}
	if (strcmp(argv[optind],"stats") == 0)
	{
		if (argsLeft != 1)
		{
			usage();
			msqlClose(sock);
			exit(1);
		}
		printf("\nServer Statistics\n");
		printf("-----------------\n\n");
		if (msqlGetServerStats(sock) == 0)
		{
			printf("\n\n");
			msqlClose(sock);
			exit(0);
		}
		else
		{
			printf("\nError getting server stats : %s\n\n",
				msqlErrMsg);
			exit(1);
		}
	}
	usage();
	msqlClose(sock);
	exit(1);
}
