/*
**	msql.h	- 
**
**
** Copyright (c) 1993  David J. Hughes
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/


#if defined(__STDC__) || defined(__cplusplus)
#  define __P(x)	x
#else
#  define __P(x)	()
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef	unsigned char	** m_row;

typedef struct field_s {
	char	*name,
		*table;
	int	type,
		length,
		flags;
} m_field;



typedef	struct	m_data_s {
	int	width;
	m_row	data;
	struct	m_data_s *next;
} m_data;

typedef struct m_fdata_s {
	m_field	field;
	struct m_fdata_s *next;
} m_fdata;



typedef struct result_s {
        m_data 	*queryData,
                *cursor;
	m_fdata	*fieldData,
		*fieldCursor;
	int	numRows,
		numFields;
} m_result;


#define	msqlNumRows(res) res->numRows
#define	msqlNumFields(res) res->numFields


#define INT_TYPE	1
#define CHAR_TYPE	2
#define REAL_TYPE	3
#define IDENT_TYPE	4
#define NULL_TYPE	5

#define NOT_NULL_FLAG   1
#define PRI_KEY_FLAG    2

#define IS_PRI_KEY(n)	(n & PRI_KEY_FLAG)
#define IS_NOT_NULL(n)	(n & NOT_NULL_FLAG)


/*
** Pre-declarations for the API library functions
*/
#ifndef _MSQL_SERVER_SOURCE
	extern  char msqlErrMsg[];
	int 	msqlConnect __P((char *));
	int 	msqlSelectDB __P((int, char*));
	int 	msqlQuery __P((int, char*));
	int 	msqlCreateDB __P((int, char*));
	int 	msqlDropDB __P((int, char*));
	int 	msqlShutdown __P((int));
	int 	msqlReloadAcls __P((int));
	int 	msqlGetProtoInfo();
	char 	*msqlGetServerInfo();
	char 	*msqlGetHostInfo();
	void	msqlClose __P((int));
	void 	msqlDataSeek __P((m_result*, int));
	void 	msqlFieldSeek __P((m_result*, int));
	void 	msqlFreeResult __P((m_result*));
        m_row   msqlFetchRow __P((m_result*));
	m_field	*msqlFetchField __P((m_result *));
	m_result *msqlListDBs __P((int));
	m_result *msqlListTables __P((int));
	m_result *msqlListFields __P((int, char*));
	m_result *msqlStoreResult();
#endif

#ifdef __cplusplus
	}
#endif
