#ifndef __ZMSQLDB_H
#define __ZMSQLDB_H

#include "zdb.h"
#include <msql.h>

class ZmSQL;
class ZmSQLConnection;


class  ZmSQL : public ZSQL	{
	private:
		m_row Row;
		m_result* Result;
		ZmSQLConnection* Connection;
		m_field Field[MAX_COLS];

	public:
		ZmSQL(ZmSQLConnection* p);

		int Open(char*);
		void Close();
		int GetSQLData(int,char*,int);
                int GetSQLData(int,int*);
                int GetSQLData(int,float*);
  		int GetNextRecord();
		int GetFieldInfo(int,ZField*);
		int GetNumCols();
		int GetNumRows();
		void PrintError(int=TO_LOG);
		void Initialize();
	};
	
class  ZmSQLConnection	:public ZDBConnection{
	public:
		int ErrCode;
		int hDB;

	public:
		ZmSQLConnection(char*,char* = NULL,char* = NULL);
		~ZmSQLConnection();
		virtual int GetDB(){return hDB;}
		virtual void ShutDown();
		virtual void Initialize();
	};

#endif
