#include "zmsql.h"

#define LOGTOFILE

ZmSQL::ZmSQL(ZmSQLConnection* p):ZSQL::ZSQL(p)
{
Initialize();
Connection=p;
}

void ZmSQL::Initialize()
{
ZSQL::Initialize();
Connection->Log("ZmSQL::Initialize successful....");
}


int ZmSQL::Open(char* sql)
{
char temp[100];
m_field* fld;
int i=0;
ZmSQLConnection* pdb=Connection;

if(IsOpen)
	Close();
Connection=pdb;
ZSQL::Open(sql);
Connection->Log("ZmSQL: Opening mSQL transaction...");
Connection->Log("Sending query: ",sql);
if(msqlQuery(Connection->GetDB(),sql)==-1)	{
	PrintError();
	IsOpen=0;
	return 0;
	}
Result=msqlStoreResult();
if(Result==NULL)	{
	PrintError();
	IsOpen=0;
	return 0;
	}
while((fld=msqlFetchField(Result)))	
	memcpy(&Field[i++],fld,sizeof(m_field));
Connection->Log("Transaction opened successfully...");
return 1;
}

void ZmSQL::Close()
{
if(IsOpen)	{
	IsOpen=0;
	Connection->Log("Closing mSQL transaction...");
	Initialize();
	msqlFreeResult(Result);
	}
}

int ZmSQL::GetSQLData(int col,char* res,int len)
{

if(col>=GetNumCols()||Row==NULL)
        return 0;
strncpy(res,Row[col],len-1);
res[len-1]=0;
return 1;
}

int ZmSQL::GetSQLData(int col,int* res)
{
if(col>=GetNumCols()||Row==NULL)
	return 0;
*res=atoi(Row[col]);
return 1;
}
int ZmSQL::GetSQLData(int col,float* res)
{
if(col>=GetNumCols()||Row==NULL)
        return 0;
*res=atof(Row[col]);
return 1;

}  

int ZmSQL::GetNextRecord()
{
if(Result==NULL)	{
	Connection->Log("Invalid Result in GetNextRecord...");	
	return 0;
	}
Row=msqlFetchRow(Result);
if(Row==NULL)	{
	Connection->Log("No data found in GetNextRecord...");
	return 0;
	}
Connection->Log("Got next record OK...");
return 1;
}

int ZmSQL::GetFieldInfo(int pos ,ZField* fld)
{
if(Result==NULL||pos>=GetNumCols())
	return 0;
sprintf(fld->Name,"%s.%s",Field[pos].table,Field[pos].name);
switch(Field[pos].type)	{
	case INT_TYPE:
		fld->Type=INT_FLD;
		break;
	case REAL_TYPE:
		fld->Type=REAL_FLD;
		break;
	case CHAR_TYPE:
		fld->Type=CHAR_FLD;
		break;
	default:
		Connection->Log("Unknown datatype...bailing");
		return 0;
	}
fld->Length=Field[pos].length;
return 1;
}

int ZmSQL::GetNumCols()
{
if(Result==NULL)
	return 0;
return msqlNumFields(Result);
}

int ZmSQL::GetNumRows()
{
if(Result==NULL)
	return 0;
return msqlNumRows(Result);
} 

void ZmSQL::PrintError(int where)
{
char temp[1024];

sprintf(temp,"mSQL Error: %s",msqlErrMsg);
if(where==TO_LOG)
        Connection->Log(temp);
else
        printf("%s",temp);
}

//***********************************************************************
//			ZDBConnection definitions
//***********************************************************************

//For mSQL the connection string comes in as host:db
//You can specify just the db if you want to connect to the internal
//mSQL daemon.  
//Currently the username and password are not used.
//In mSQL this would have to be implemented by suid to the username passed to
//this constuctor.

ZmSQLConnection::ZmSQLConnection(char *ConnectInfo,char* User,char* Pass):ZDBConnection::ZDBConnection(ConnectInfo,User,Pass)
{
char* CIPtr;

CIPtr=strstr(ConnectInfo,":");
if(CIPtr)	{
	*CIPtr='\0';
	CIPtr++;
	hDB=msqlConnect(ConnectInfo);
	Log("Connecting to network mSQL DB: ",ConnectInfo);
	}
else	{
	CIPtr=ConnectInfo;
	hDB=msqlConnect(NULL);
	Log("Connecting to internal mSQL DB");
	}
if(hDB==-1)	{
	Log(msqlErrMsg);
	return;
	}
ErrCode=msqlSelectDB(hDB,CIPtr);
if(ErrCode==-1)	{
	Log(msqlErrMsg);
	msqlClose(hDB); 
	return;
	}
Log("Connected to msql Data Source!");
IsConnected=1;
}

ZmSQLConnection::~ZmSQLConnection()
{
ShutDown();
}

//****************************************************************************
//				ShutDown
//****************************************************************************
void ZmSQLConnection::ShutDown()
{
if(!IsConnected)
	return;
msqlClose(hDB);
Initialize();
}

//****************************************************************************
//				Initialize
//****************************************************************************
void ZmSQLConnection::Initialize()
{
ZDBConnection::Initialize();
ConnectInfo[0]='\0';
User[0]='\0';
Password[0]='\0';
ErrorMessage[0]='\0';
IsConnected=0;
Type=MSQL_DB;
}

