/* Kees Lemmens; May 1996 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Xsqldefs.h"

int CheckTableSelected(FD_Xsql *fd_Xsql)
{  Info_t *I = (Info_t *)fd_Xsql->vdata;
   
   if(fl_get_choice(fd_Xsql->XsqlTable) == 1 ||
      I->Numflds == 0)
   {
      fl_show_message("Select a table first !","","");
      return -1; /* none selected */
   }
   else
     return 0;
}

int ExecuteQuery(Info_t *I,char *query)
{
   Info(I->Xsql,"Executing: %s",query);
   if (msqlQuery(sock,query))
   {
      SqlError("Query failed");
      return -1;
   }
   return 0;
}
   
char *TypeConvert(char *target,const char *string,int type)
{
   if(type == CHAR_TYPE)
     sprintf(target,"'%s'",string);
   else
     sprintf(target,"%s",string); 

   return target;
}

void FreeInfoStruct(Info_t *I)
{
   int x;
   
   for(x=0;x<I->Numflds;x++)
     free(I->Fields[x].name);
   free(I->Fields);
   free(I->Table);
   free(I);
}

Info_t *CopyInfoStruct(Info_t *S)
{  int   x;
   Info_t *D;
   
   D = (Info_t *) malloc(sizeof(Info_t));
   D->Numflds = S->Numflds;
   D->Table   = (char *)malloc(strlen(S->Table) + 1);
   strcpy(D->Table,S->Table);
   D->Xsql    = S->Xsql;
   D->Res     = NULL; /* avoid closing a Result by accident */
   
   D->Fields = (m_field *)malloc(S->Numflds * sizeof(m_field));
   for(x=0;x<S->Numflds;x++)
   {
      memcpy(&D->Fields[x],&S->Fields[x],sizeof(m_field));

      /* now save (copy) the pointer elements (name and table) */
      /* as they'll be lost after release of the selection */
      
      if((D->Fields[x].name = (char *)malloc(strlen(S->Fields[x].name) + 1)) == NULL)
      {
	 SqlError("Not enough memory to store fieldnames !");
	 exit(1);
      }
      strcpy(D->Fields[x].name,S->Fields[x].name);
      D->Fields[x].table = D->Table; /* useless to copy  */
   }
   return D;
}

Info_t *SetInfoStruct(char *table,FD_Xsql *fd_Xsql)
{  char *ptr;
   int   x;
   m_result *res;
   Info_t *I;
   
   if ((res = msqlListFields(sock,table)) == NULL) /* obtain all fields in table */
   {
      SqlError("Cannot fetch fieldnames for %s",table);
      return 0;
   }
   
   I = (Info_t *) malloc(sizeof(Info_t));

   I->Numflds = msqlNumFields(res); /* get number of fields */
   I->Table   = (char *)malloc(strlen(table) + 1);
   strcpy(I->Table,table);
   I->Xsql    = fd_Xsql;
   I->Res     = NULL;
   
   I->Fields = (m_field *)malloc(I->Numflds * sizeof(m_field));
   for(x=0;x<I->Numflds;x++)
   {
      memcpy(&I->Fields[x],msqlFetchField(res),sizeof(m_field));

      /* now save (copy) the pointer elements (name and table) */
      /* as they'll be lost after release of the selection */
      
      if((ptr = (char *)malloc(strlen(I->Fields[x].name) + 1)) == NULL)
      {
	 SqlError("Not enough memory to store fieldnames !");
	 exit(1);
      }
      strcpy(ptr,I->Fields[x].name);
      I->Fields[x].name = ptr;
      I->Fields[x].table = I->Table; /* useless to copy */
   }
   msqlFreeResult(res);
   return I;
}

int GetNumRecords(Info_t *I)
{  m_result *res;
   char query[MAXQUERY];
   int numrecs;
   
   sprintf(query,SELECT,I->Table);

   if (ExecuteQuery(I,query))
      return 0;
   
   res = msqlStoreResult();
   numrecs = msqlNumRows(res);

   msqlFreeResult(res);
   return numrecs;
}

void SetCounters(int NrFields,int NrRecords,FD_Xsql *fd_Xsql)
{  char string[MAXSTRING];
   
   sprintf(string,"%d",NrFields);
   fl_set_object_label(fd_Xsql->XsqlFieldCount,string);
   sprintf(string,"%d",NrRecords);
   fl_set_object_label(fd_Xsql->XsqlRecordCount,string);
}

void ClearList(FL_OBJECT *ob)
{
   fl_clear_choice(ob);
   fl_addto_choice(ob,"None selected"); 
}

void SetDatabaseList(FL_OBJECT *ob)
{
   m_result  *res;
   m_row      row;
   
   if (sock == 0)
   {
      Message("Cannot fetch databases");
      return;
   }
   res = msqlListDBs(sock);

   ClearList(ob);
   while((row = msqlFetchRow(res)) != NULL)
      fl_addto_choice(ob,row[0]);
   msqlFreeResult(res);
}

void SetTableList(FL_OBJECT *ob)
{
   m_result  *res;
   m_row      row;
   
   if (sock == 0)
   {  
      Message("Cannot fetch tables");
      return;
   }
   res = msqlListTables(sock);
   ClearList(ob);
   
   while((row = msqlFetchRow(res)) != NULL)
     fl_addto_choice(ob,row[0]);
   msqlFreeResult(res);
}

void SetNewTable(char *table,FD_Xsql *fd_Xsql)
{
   Info_t *Info;
   
   /* First free previous info struct to avoid memory leaks */
   if(fd_Xsql->vdata != NULL)
   {
      FreeInfoStruct((Info_t *)fd_Xsql->vdata);
      fd_Xsql->vdata = NULL;
   }
   
   fl_set_choice_text(fd_Xsql->XsqlTable,table);

   if(fl_get_choice(fd_Xsql->XsqlTable) == 1) /* None selected */
   {
      SetCounters(0,0,fd_Xsql);
      return;
   }
   Info = SetInfoStruct(table,fd_Xsql);
   
   fd_Xsql->vdata = (void *)Info; /* attach Table info to form structure ! */
   SetCounters(Info->Numflds, GetNumRecords(Info),fd_Xsql);
}

void SetNewDatabase(char *database,FD_Xsql *fd_Xsql)
{
   fl_set_choice_text(fd_Xsql->XsqlDatabase,database);

   if(fl_get_choice(fd_Xsql->XsqlDatabase) > 1) /* None selected */
   {
      if(msqlSelectDB(sock,database) < 0)
      {
	 SqlError("Error opening database %s",database);
	 return;
      }
      SetTableList(fd_Xsql->XsqlTable);
   }
   else
     ClearList(fd_Xsql->XsqlTable);
   SetCounters(0,0,fd_Xsql);
}

void SetNewServer(char *server,FD_Xsql *fd_Xsql)
{
   if(server != NULL)
   {
      fl_set_input(fd_Xsql->XsqlServer,server);
      if (*server == '\0')
	server = NULL;  /* provide for empty but not NULL string */
   }
      
   if ((sock = msqlConnect(server)) < 0)
   {  SqlError("Error connecting to server");
      ClearList(fd_Xsql->XsqlDatabase);
   }
   else
     SetDatabaseList(fd_Xsql->XsqlDatabase);

   ClearList(fd_Xsql->XsqlTable);
   SetCounters(0,0,fd_Xsql);
}
