#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Xsqldefs.h"

void XsqlSQLQuery(FL_OBJECT *ob, long parent)
{
   FD_Xsql   *Xsql = (FD_Xsql *)parent;
   Info_t    I,*L;
   FD_Shower *fd_Shw;
   m_row      row;
   int        x,numrows;
   char       *ptr;
   static char query[MAXQUERY] = "SELECT ";
   
   if(CheckTableSelected(Xsql) < 0)
     return;
   strncpy(query,fl_show_input("Enter SQL Select statement :",query),
	   MAXQUERY);
   
   I.Xsql = Xsql;
   
   if (ExecuteQuery(&I,query))
     return;
   if((I.Res = msqlStoreResult()) == NULL)
     return; /* This can happen with i.e. a DROP query ! */
   
   I.Numflds = msqlNumFields(I.Res);
   
   /* Must malloc as FreeResult will try to free it when closing Browser ! */
   I.Table = (char *)malloc(1);
   *I.Table = '\0'; /* don't need a tablename as selection is not allowed */
     
   if((I.Fields = (m_field *)malloc(I.Numflds * sizeof(m_field))) == NULL)
   {
      SqlError("Not enough memory to store fieldnames !");
      exit(1);
   }
   for(x=0;x<I.Numflds;x++)
   {
      memcpy(&I.Fields[x],msqlFetchField(I.Res),sizeof(m_field));
      
      /* now save (copy) the pointer elements (name) */
      /* as they'll be lost after release of the selection */
      
      ptr = (char *)malloc(strlen(I.Fields[x].name) + 1); /* check !!! */
      strcpy(ptr,I.Fields[x].name);
      I.Fields[x].name = ptr;
      I.Fields[x].table = I.Table; /* useless to copy */
   }
   
   Message("Selection of records is disabled as it can have \n"
	   "unpredictable side effects with free queries !");
   fd_Shw = BuildShowerForm(&I,"Show Free Query",PASSIVE);
   
   L = (Info_t *) fd_Shw->vdata;
   L->Res = I.Res;
   
   numrows = msqlNumRows(L->Res);/* get number of records in selection */
   
   fl_freeze_form(fd_Shw->Shower);
   
   for(x=0;x < numrows;x++)
   {
      if((row = msqlFetchRow(I.Res)) == NULL)
      {
	 SqlError("Error reading record !");
	 return;
      }
      WriteToBrowser(&I,fd_Shw->Browser,row);
   }
   fl_unfreeze_form(fd_Shw->Shower);
}

