#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Xsqldefs.h"

void XsqlFieldInfo(FL_OBJECT *ob, long parent)
{
   FD_Xsql *Xsql = (FD_Xsql *)parent;
   Info_t  *I    = (Info_t *) Xsql->vdata;
   FD_Shower *fd_Shw;
   char buffer[MAXSTRING];
   char *type;
   int x;
   
   if(CheckTableSelected(Xsql) < 0)
     return;

   fd_Shw = BuildShowerForm(I,"Field descriptions",PASSIVE);

   fl_freeze_form(fd_Shw->Shower);

   sprintf(buffer,"%18s %18s %8s %8s %12s %8s","Fieldname","Tablename",
	   "Length","Type","Prim. Key","Not Null");
   fl_add_browser_line(fd_Shw->Browser,buffer);

   for(x=0;x < I->Numflds;x++)
   {
      switch(I->Fields[x].type)
      {
       case CHAR_TYPE: type = "Character"; break;
       case INT_TYPE : type = "Integer";   break;
       case REAL_TYPE: type = "Real";      break;
       default:
	 Message("Unknown fieldtype detected !");
	 type = "Unknown"; break;
      }
      
      sprintf(buffer,"%18s %18s %6d   %10s %8s %8s",I->Fields[x].name,
	      I->Table,I->Fields[x].length,
	      type,IS_PRI_KEY(I->Fields[x].flags) ? "Y" : "N",
	      IS_NOT_NULL(I->Fields[x].flags) ? "Y" : "N"
	      );
      
      fl_add_browser_line(fd_Shw->Browser,buffer);
   }
   fl_unfreeze_form(fd_Shw->Shower);
}
