#ifndef ABSOLUTE_H
#define ABSOLUTE_H
/*
**	An absolute date is a an integer representing the number of days
**	since 12/1/1 BC, i.e., day 1 is 1/1/1 AD.
**
**	The functions below manipulate absolute dates.
**
**	This work is derived from GNU software, so you should read
**	the GNU license agreement if you are plannning to use
**	them in commercial software.
*/

typedef int ABSOLUTE_DAY;

extern ABSOLUTE_DAY gregorian_to_absolute (int day, int month, int year);
extern ABSOLUTE_DAY current_absolute_date (void);

extern int absolute_to_gregorian_day (ABSOLUTE_DAY date);
extern int absolute_to_gregorian_month (ABSOLUTE_DAY date);
extern int absolute_to_gregorian_year (ABSOLUTE_DAY date);

extern WEEKDAY absolute_to_weekday (ABSOLUTE_DAY date);

#endif /* ABSOLUTE_H */
