/******************************************************/
/*  A set of CGI utility functions.  Some of my own   */
/*  creation and some from the good people at NSCA.   */
/*  Phil Leach <pleach@nerosworld.com>                */
/******************************************************/

#include <stdio.h>
#include <time.h>
#include <string.h>
#include "util.h"

void getword(char *word, char *line, char stop)
{
	int x,
  		y;

  for (x=0; ((line[x]) && (line[x] != stop)); x++)
  {
  	word[x] = line[x];
  }

  word[x] = '\0';
  
  if(line[x])
  {
  	++x;
  }
  
  y = 0;

  while(line[y++] = line[x++]);
  
  return;
}

char *makeword(char *line, char stop)
{
	int x,
			y;
			
	char *word = (char *) malloc(sizeof(char) * (strlen(line) + 1));

  for(x=0;((line[x]) && (line[x] != stop));x++)
  {
  	word[x] = line[x];
  }

 	word[x] = '\0';
 	
  if (line[x])
  {
  	++x;
  }
  
  y=0;

  while(line[y++] = line[x++]);
  
	return word;
}

char *fmakeword(FILE *f, char stop, int *cl)
{
	int wsize = 102400,
			i = 0;
			
	char *word = (char *) malloc(sizeof(char) * (wsize + 1));

	while (1)
	{
  	word[i] = (char)fgetc(f);
  	
  	if (i == wsize)
  	{
    	word[i+1] = '\0';
    	wsize += 102400;
    	word = (char *)realloc(word,sizeof(char)*(wsize+1));
    }
    
    --(*cl);
    
   	if ((word[i] == stop) || (feof(f)) || (!(*cl)))
   	{
    	if (word[i] != stop)
    	{
    		i++;
    	}
    	
      word[i] = '\0';
      
      return word;
    }
    
    ++i;
 	}
}

char x2c(char *what)
{
	register char digit;

  digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
  digit *= 16;
  digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
  return(digit);
}

void unescape_url(char *url)
{
	register int x,
							 y;

	for (x=0, y=0; url[y]; ++x, ++y)
	{
  	if ((url[x] = url[y]) == '%')
  	{
    	url[x] = x2c(&url[y+1]);
      y+=2;
    }
  }
  
  url[x] = '\0';
  
  return;
}

void plustospace(char *str)
{
	register int x;

	for (x=0; str[x]; x++)
	{
 		if (str[x] == '+')
 		{
 			str[x] = ' ';
 		}
 	}
 	
 	return;
}

int rind(char *s, char c)
{
	register int x;
	
	for (x = strlen(s) - 1; x != -1; x--)
	{
  	if (s[x] == c)
  	{
  		return x;
  	}
  }
  
  return -1;
}

int getline(char *s, int n, FILE *f)
{
	register int i = 0;

	while(1)
	{
  	s[i] = (char)fgetc(f);

  	if (s[i] == CR)
  	{
    	s[i] = fgetc(f);
    }

    if ((s[i] == 0x4) || (s[i] == LF) || (i == (n-1)))
    {
    	s[i] = '\0';
      return (feof(f) ? 1 : 0);
    }
    
    ++i;
	}
}

void send_fd(FILE *f, FILE *fd)
{
	int num_chars = 0;
	
  char c;

  while (1)
  {
  	c = fgetc(f);
  	
   	if (feof(f))
   	{
    	return;
    }
    
    fputc(c,fd);
 	}
}

int ind(char *s, char c)
{
	register int x;

	for (x=0; s[x]; x++)
	{
  	if (s[x] == c)
  	{
  		return x;
  	}
  }

	return -1;
}


/* My routines start here */

int GetIndex(entry list[], char *string, int numEntries)
{
	int i;
	
	for (i = 0; i < numEntries; i++)
	{
		if (!strcmp(list[i].name, string))
		{
			return i;
		}
	}
	
	return -1;
}

void LogError(char *whatToLog, char *fileName)
{
	FILE *outFile;
	
	char buf1[4096],
			 buf2[1024];
			 
	time_t theTime;
	
	struct tm *fTime;
	
	time(&theTime);
	
	fTime = localtime(&theTime);
	
	strftime(buf1, (sizeof(buf1) - strlen(whatToLog)), "%m/%d/%Y %H:%M:%S - ", fTime);
	strcat(buf1, whatToLog);

	outFile = fopen(fileName, "a");
	if (!outFile)
	{
 		sprintf(buf2, "Could not open %s to log: %s", fileName, whatToLog);
 		sprintf(buf1, SEVERE_CGI_ERR, buf2);
  	printf("%s%c", buf1, LF);
  	exit(1);
  }
  
  fputs(buf1, outFile);
  
  if (ferror(outFile))
  {
  	sprintf(buf2, "Could not write %s to %s", whatToLog, fileName);
  	sprintf(buf1, SEVERE_CGI_ERR, buf2);
  	printf("%s%c", buf1, LF);
  	exit(1);
	}
  
	fclose(outFile);
}


/* Do any needed clean up before dying while processing the database */

void HardExit(int sock, m_result *result)
{
	if (sock > -1)
	{
		msqlClose(sock);
	}
	
	if (result)
	{
		msqlFreeResult(result);
	}
	
	exit(1);
}


/* Format the price to nnn,nnn,nnn.nn */

char *FormatPrice(double inPrice, char *outPrice)
{
	char buf[15],
			 buf2[15],
			 *cPtr,
			 *tPtr;
	
	int i,
			j;
	
	sprintf(buf, "%.2f", inPrice);
	
	cPtr = strstr(buf, ".");
	
	/* Process everything left of the '.' backwards setting a ',' after every 3rd digit */
	
	for (tPtr = (cPtr - 1), i = 0, j = 0; tPtr >= buf; j++, tPtr--)
	{
		if (j == 3)
		{
			buf2[i++] = ',';
			j = 0;
		}
		
		buf2[i++] = *tPtr;
	}
	
	/* Now reverse the order */
	
	for (i--, j = 0; i >= 0; i--, j++)
	{
		outPrice[j] = buf2[i];
	}
	
	outPrice[j] = '\0';
	
	/* Now add the stuff after the decimal */
	
	strcat(outPrice, cPtr);
	
	return (outPrice);
}


/* Escape '\' and ''' chars for input strings */

void msqlInsEscape(char *inString, char *outString)
{
    int i,
    		indx;

    indx = 0;
    for (i = 0;  i < strlen(inString);  i++)
    {
     	if (inString[i] == '\'' || inString[i] == '\\') 
     	{
       	outString[indx++] = '\\';
        outString[indx++] = inString[i];
      }
      else
      {
      	outString[indx++] = inString[i];
      }
    }
   
    outString[indx] = '\0';

    return;
}
	
	
/* Do the work of a server side include */

void DoSSI(char *inStr, char *logFile)
{
	char *cPtr1,
			 *cPtr2,
			 fName[256],
			 buf[100],
			 errBuf[356];
			 
	int i;
			 
	FILE *incFile;
			 
	cPtr1 = strstr(inStr, INC_STR);
	cPtr2 = inStr;
	
	while (cPtr1)
	{
		*cPtr1 = '\0';
		
		if (strlen(cPtr2))
		{
			printf(cPtr2);
		}
		
		cPtr1 = strchr(++cPtr1, '"');
		
		for (i = 0, cPtr1++; *cPtr1 != '"'; i++, cPtr1++)
		{
			fName[i] = *cPtr1;
		}
		
		fName[i] = '\0';
		
		incFile = fopen(fName, "r");
		if (!incFile)
		{
			sprintf(errBuf, "Could not open %s\n", fName);
			LogError(logFile, errBuf);
			printf(CGI_ERR);
			exit(1);
		}
		
		while (!feof(incFile))
		{
			fgets(buf, sizeof(buf), incFile);
			if (ferror(incFile))
			{
				sprintf(errBuf, "Could not read %s\n", fName);
				LogError(logFile, errBuf);
				printf(CGI_ERR);
				exit(1);
			}
			
			printf(buf);
		}
		
		fclose(incFile);
		
		cPtr2 = cPtr1 + 4;
		
		cPtr1 = strstr(cPtr2, INC_STR);
	}
	
	if (strlen(cPtr2))
	{
		printf(cPtr2);
	}
	
	return;
}


/* Get items from a configuration file */

int GetConfig(char *keyname, char *dataname, char *configFileName)
{ 
  FILE *cfgfile;

  int key_len,
      data_len;

  char data[CFG_REC_LEN],
       *line;

  key_len = strlen(keyname);

  cfgfile = fopen(configFileName, "r");
  if (!cfgfile)
  { 
    return(OPEN_FAILED);
  }

  while(line = fgets(data, CFG_REC_LEN, cfgfile))
  { 
    if ((strncmp(data, keyname, key_len) == 0) &&
        (*(line + key_len)               == '='))
    { 
      data_len = strlen(data);
      line[data_len - 1] = '\0';
      strcpy(dataname, line + key_len + 1);
      fclose(cfgfile);
      return(GOOD);
    }
  }

  fclose(cfgfile);
  return(NOT_FOUND);
}
	
	
/* Why duplicate this code each time we call GetConfig? */
	
void CheckConfigReturn(int rc, char *buf)
{
	char errBuf[100];
	
	switch (rc)
	{
		case GOOD:
			break;
			
		case OPEN_FAILED:
			printf(SEVERE_CGI_ERR, BAD_CONFIG_OPEN);
			exit(1);
			break;
			
		case NOT_FOUND:
			sprintf(errBuf, MISSING_ITEM, buf);
			printf(SEVERE_CGI_ERR, errBuf);
			exit(1);
			break;
	}
	
	return;
}
