/*****************************************/
/* summary.c                             */
/* Author: Phil Leach                    */
/* pleach@nerosworld.com
/* Date: 04/19/96                        */
/*                                       */
/* This program will use a config file   */
/* whose name is past in to build a      */
/* summary table from a larger table.    */
/* The config file has the host and db   */
/* names along with the search clause,   */
/* the insert clause and an optional     */
/* delete clause.
/*****************************************/

/* System Includes */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

/* My includes */

#include "util.h"

/* Defines and structure defs */

#define USAGE "%s requires 1 input1:\n\tThe config file name\n"

#define NUM_PARM 1

#define BAD_CONNECT "The attempt to connect to host %s failed:\n%s\n"
#define BAD_SELECT "The attempt to select database %s failed:\n%s\n"
#define BAD_QUERY "The attempt to run the query\n  %s failed:\n%s\n"
#define BAD_INSERT "The attempt to run the insert\n  %s failed:\n%s\n"
#define BAD_DELETE "The attempt to run the delete\n  %s failed:\n%s\n"
#define BAD_STORE "The attempt to store the query results failed:\n%s\n"
#define BAD_NUM_FIELD "Your query must select at least 1 and no more than 10 fields.  You selected %d."

/* Internal Function Prototypes */

void GetConfigItems(void);
void DoBuild(void);
void ChkCfgRet(int rc, char *buf);

/* Globals */

char *cfgFile,
     host[101],
		 dbName[101],
		 selectClause[1024],
		 insertClause[1024],
		 deleteClause[1024];

int sock;
										
enum {CONFIG_NAME = 1};

/* mainline */

void main (int argc, char *argv[])
{
	int rc;
	
	if (argc < (NUM_PARM + 1))
	{
		printf(USAGE, argv[0]);
		return;
	}
	
	cfgFile = argv[CONFIG_NAME];
	
	GetConfigItems();
	
	sock = msqlConnect(host);
	if (sock == -1)
	{
		printf(BAD_CONNECT, host, msqlErrMsg);
		HardExit(sock, NULL);
	}
	
	rc = msqlSelectDB(sock, dbName);
	if (rc == -1)
	{
		printf(BAD_SELECT, msqlErrMsg);
		HardExit(sock, NULL);
	}
	
	DoBuild();
	
	msqlClose(sock);
	
	return;
} 


/* Get some needed items from the config file */

void GetConfigItems(void)
{
	int rc;
	
	char buf[50];
	
	strcpy(buf, "HOST");
	
	rc = GetConfig(buf, host, cfgFile);
	
	if (rc == NOT_FOUND)
	{
		strcpy(host, "localhost");
	}
	else
	{
		ChkCfgRet(rc, buf);
	}
	
	strcpy(buf, "DB_NAME");
	
	rc = GetConfig(buf, dbName, cfgFile);
	
	ChkCfgRet(rc, buf);
	
	strcpy(buf, "SELECT_CLAUSE");
	
	rc = GetConfig(buf, selectClause, cfgFile);
	
	ChkCfgRet(rc, buf);
	
	strcpy(buf, "INSERT_CLAUSE");
	
	rc = GetConfig(buf, insertClause, cfgFile);
	
	ChkCfgRet(rc, buf);
	
	strcpy(buf, "DELETE_CLAUSE");
	
	rc = GetConfig(buf, deleteClause, cfgFile);
	
	if (rc != NOT_FOUND)
	{
		ChkCfgRet(rc, buf);
	}
	else
	{
		deleteClause[0] = '\0';
	}
	
	return;
}


/* Build the requested table */

void DoBuild(void)
{
	int rc,
			numFields;
	
	char insStr[4096];
	
	m_result *result = NULL;
		
	m_row thisRow;
	
	enum {INIT};
	
	rc = msqlQuery(sock, selectClause);
	if (rc == -1)
	{
		printf(BAD_QUERY, selectClause, msqlErrMsg);
		HardExit(sock, result);
	}
	
	if ((result = msqlStoreResult()) == NULL)
	{
		printf(BAD_STORE, msqlErrMsg);
		HardExit(sock, result);
	}
	
	if (strlen(deleteClause))
	{
		rc = msqlQuery(sock, deleteClause);
		if (rc == -1)
		{
			printf(BAD_DELETE, deleteClause, msqlErrMsg);
			HardExit(sock, result);
		}
	}
	
	numFields = msqlNumFields(result);
		
	while ((thisRow = msqlFetchRow(result)) != NULL)
	{
	  switch(numFields)
	  {
	  	case 1:
				sprintf(insStr, insertClause, thisRow[0]);
				break;
				
	  	case 2:
				sprintf(insStr, insertClause, thisRow[0], thisRow[1]);
				break;
				
	  	case 3:
				sprintf(insStr, insertClause, thisRow[0], thisRow[1], thisRow[2]);
				break;
				
	  	case 4:
				sprintf(insStr, insertClause, thisRow[0], thisRow[1], thisRow[2],
								thisRow[3]);
				break;
				
	  	case 5:
				sprintf(insStr, insertClause, thisRow[0], thisRow[1], thisRow[2],
								thisRow[3], thisRow[4]);
				break;
				
	  	case 6:
				sprintf(insStr, insertClause, thisRow[0], thisRow[1], thisRow[2],
								thisRow[3], thisRow[4], thisRow[5]);
				break;
				
	  	case 7:
				sprintf(insStr, insertClause, thisRow[0], thisRow[1], thisRow[2],
								thisRow[3], thisRow[4], thisRow[5], thisRow[6]);
				break;
				
	  	case 8:
				sprintf(insStr, insertClause, thisRow[0], thisRow[1], thisRow[2],
								thisRow[3], thisRow[4], thisRow[5], thisRow[6], thisRow[7]);
				break;
				
	  	case 9:
				sprintf(insStr, insertClause, thisRow[0], thisRow[1], thisRow[2],
								thisRow[3], thisRow[4], thisRow[5], thisRow[6], thisRow[7],
								thisRow[8]);
				break;
				
	  	case 10:
				sprintf(insStr, insertClause, thisRow[0], thisRow[1], thisRow[2],
								thisRow[3], thisRow[4], thisRow[5], thisRow[6], thisRow[7],
								thisRow[8], thisRow[9]);
				break;
				
			default:
				printf(BAD_NUM_FIELD, numFields);
				HardExit(sock, result);
				break;
		}
				
		rc = msqlQuery(sock, insStr);
		if (rc == -1)
		{
			printf(BAD_INSERT, insStr, msqlErrMsg);
			HardExit(sock, result);
		}
	}
	
	msqlFreeResult(result);
	
	puts("Summary table successfully built");
		
	return;
} 
	
	
/* Why duplicate this code each time we call GetConfig? */
	
void ChkCfgRet(int rc, char *buf)
{
	switch (rc)
	{
		case GOOD:
			break;
			
		case OPEN_FAILED:
			printf(BAD_CONFIG_OPEN);
			exit(1);
			break;
			
		case NOT_FOUND:
			printf(MISSING_ITEM, buf);
			exit(1);
			break;
	}
	
	return;
}
