/*
 * Filename: simple.c
 * Project:  Sequence Generation System
 * Module:   Examples
 *
 * Function: This program demonstrates the use of the basic API functions
 *
 * Author:   Pascal Forget (pascal@wsc.com)
 * Date:     May 1995
 *
 * Copyright (C)1995 Pascal Forget
 *
 * You may freely distribute, copy or modify this program.
 */

#include "../../api/sgs.h"
#include <stdio.h>

int main(void)
{
    const char *sequenceName = "Sequence1";
    SGAnswer answer;
    int i;
    unsigned int currentValue;

    /*
     * Create the sequence if it doesn't already exist
     */
    sgsCreateSequence(sequenceName);

    /*
     * Display the next 10 values of the sequence
     */
    
    for(i=0; i<100; i++) {
	answer = sgsNextValue(sequenceName);
	    
	if (answer.returnStatus == 0) {
	    fprintf(stderr, "Error getting the sequence's next value.\n");
	    break;
	} else {

	    currentValue = answer.value;
	    
	    fprintf(stdout, "Sequence %s next value: %u\n",
		    sequenceName, currentValue);
	}
    }

    return 0;
}
