/*
 * Filename:	main.h
 * Project:	Sequence Generation System
 * Module:	Daemon
 * Function:	This is the engine of the sequence generator.
 *
 * Author:	Pascal Forget
 * Date:	October 1995
 *
 * (C) 1995 Pascal Forget
 * All Rights reserved.
 *
 * This software falls under the GNU General Public Licence, as published
 * by FSF, the Free Software Foundation.  You should have received a copy 
 * of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge,
 * MA 02139, USA.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef MAIN_H__
#define MAIN_H__

#include "../api/sgsCommon.h"

typedef struct {
    char name[SEQ_NAME_LEN];
    unsigned int value;
    unsigned short int leftInCache;
    unsigned int increment;
    unsigned short int cache;
} Definition;

typedef struct {
    unsigned int valuesStreamVersion;
    unsigned int numberOfEntries;
} DefsHeader;

typedef struct {
    int index;
    unsigned char exactMatch;
} Location;

int
sgsCreateFilenames(const char * path);

SGAnswer
sgsCreateSequence(SGRequest req);

SGAnswer
sgsDropSequence(SGRequest req);

SGAnswer
sgsGetSetting(SGRequest req);

SGAnswer
sgsGetValue(SGRequest req);

int
sgsInit(void);

int
sgsInsertDefinition(Definition newDef, Location loc);

int
sgsListenOnTheSocket(void);

int
sgsLoadNextValuesFromFile(int index);

Location
sgsLocate(const char *name);

Location
sgsLocateSequentially(int min, int max, const char *name);

Location
sgsLocateInSubset(int min, int max, const char *name);

SGAnswer
sgsProcessRequest(int stream);

void
sgsQuit(int status);

int
sgsReadDefinitionsVersion0(int filedesc);

int
sgsReadSequenceDefinitions(void);

int
sgsReadValues(void);

SGAnswer
sgsSetCache(SGRequest req);

SGAnswer
sgsSetIncrement(SGRequest req);

SGAnswer
sgsSetValue(SGRequest req);

int
sgsWriteDefinitions(void);

int
sgsWriteValues(void);

#endif
