/*
 * Filename: sgsCommon.h
 * Project:  Sequence Generation System
 * Module:   API
 *
 * Function: The functions that are declared in this header file are
 *           for internal use of the sequence generator API and daemon.
 *           They are not meant to be invoked directly by the user.
 *
 * Author:   Pascal Forget
 * Date:     May 1995
 *
 * Copyright (C) 1995 Pascal Forget
 *
 * This software falls under the GNU General Public License as published
 * by the Free Software Foundation.  See the COPYING file for more
 * information.
 */

#ifndef SGSCOMMON_H__
#define SGSCOMMON_H__

#include "site.h"

#define SEQ_NAME_LEN 24
#define SEQ_NOT_FOUND -1

/* Default port to be used if there's no entry in /etc/services */
#define DM_PORT 6167
#define DM_NAME "sgsd"
#define DEFAULT_DM_FILENAME "/usr/local/sgs/sgsd"

#define SEQ_INT_STRLEN 10
#define SEQ_PATHLEN 128

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <netdb.h>
#include <netinet/in.h>
/* #include <sys/uio.h> */
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <ctype.h>
#include <arpa/inet.h>

/* Defines for Solaris.
 * bzero and bcopy do not exist on Solaris (system V).
 */
#define bcopy(src, dest, len) (memmove(dest, src, len))
#define bzero(src, len) (memset(src, '\0', len))

typedef enum {
    SG_createSequence=0,
    SG_dropSequence=1,
    SG_currentValue=2,
    SG_nextValue=3,
    SG_cache=4,
    SG_increment=5,
    SG_setCache=6,
    SG_setIncrement=7,
    SG_setValue=8
} SGRequestType;

typedef struct {
    unsigned char rtype;     /* Character representation of an SGRequestType */
    char sequenceName[SEQ_NAME_LEN];
    char arg[SEQ_INT_STRLEN];    /* String representation of an unsigned int */
} SGASCIIRequest;

typedef struct {
    char value[SEQ_INT_STRLEN];  /* String representation of an unsigned int */
    unsigned char returnStatus;
} SGASCIIAnswer;

typedef struct {
    SGRequestType rtype;
    char sequenceName[SEQ_NAME_LEN];
    unsigned int arg;
} SGRequest;

typedef struct {
    unsigned int value;
    int returnStatus;
} SGAnswer;

/* Conversion functions */

SGAnswer
sgsConvertAnswerFromAscii(SGASCIIAnswer answer);

SGASCIIAnswer
sgsConvertAnswerToAscii(SGAnswer answer);

SGRequest
sgsConvertRequestFromAscii(SGASCIIRequest req);

SGASCIIRequest
sgsConvertRequestToAscii(SGRequest req);

/* Socket functions */
int
sgsGetPortNumber(void);

#endif
