/*************************************************************************
 msqlexpire: module to remove records from a mSQL database based on age.
 ************************************************************************* 
 *
 * Copyright (c), 1994-1995, by B. Scott Burkett
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All modifications to the source code must not be distributed without
 *    the permission of B. Scott Burkett.
 * 4. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by B. Scott Burkett and
 *      other unpaid contributors.
 * 5. The name of B. Scott Burkett may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY B. SCOTT BURKETT AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL B. SCOTT BURKETT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 ***************************************************************************** 
 $Header: /opt/home/staff/scottb/msqlexpire/RCS/parse.c,v 1.2 1996/07/06 19:09:13 scottb Exp scottb $
 ***************************************************************************
 $Log: parse.c,v $
 * Revision 1.2  1996/07/06  19:09:13  scottb
 * Added support for the -e (expire by date) switch
 *
 * Revision 1.1  1996/07/06  16:05:40  scottb
 * Initial revision
 *
 ***************************************************************************
 *                                                                         *
 * void ParseCmdLine(int ac, char *av[]);                                  *
 *                                                                         *
 * This function is responsible for parsing the command line and      	   *
 * setting any parameters wihch are configurable from the command line.    *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <getopt.h>

#include "msql.h"
#include "strlib.h"

#include "msqlexpire.h"

void ParseCmdLine(int ac, char *av[])
{
	int rc;
	char *option_list="d:t:h:T:n:D:k:se";

	if(ac==1) {
		printf("\nmsqlexpire " VERSION " : age based row expiry utility\n");
		printf("(C)opyright 1996, B. Scott Burkett, All Rights Reserved\n\n");

		printf("USAGE: ");
		printf("msqlexpiry: -d database -t table -h host -T ttl_fld -n notify_fld\n");
		printf("            -D date_fld -k key_field -s(safe_mode_enabled) -e(expire by date)\n\n");

		exit(0);
	}


	while((rc = getopt(ac, av, option_list)))
	{
		switch(rc)
		{
			case ':': fprintf(stderr, "Invalid parameter! Aborting\n");
				  exit(EXIT_FAILURE);
				
			case '?': fprintf(stderr, "Invalid option! Aborting\n");
				  exit(EXIT_FAILURE);
				
			case -1: return;

			case 'd': strcpy(database_name, optarg); break;
			case 't': strcpy(table_name, optarg); break;
			case 'h': strcpy(host_name, optarg); break;
			case 'T': ttl_field=atoi(optarg); break;
			case 'n': notify_field=atoi(optarg); break;
			case 'D': date_field=atoi(optarg); break;
			case 'k': key_field=atoi(optarg); break;
			case 's': safe_mode=TRUE; break;
			case 'e': expire_by_date=TRUE; break;
		}			

	}
}
