/*************************************************************************
 msqlexpire: module to remove records from a mSQL database based on age.
 ************************************************************************* 
 *
 * Copyright (c), 1994-1995, by B. Scott Burkett
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All modifications to the source code must not be distributed without
 *    the permission of B. Scott Burkett.
 * 4. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by B. Scott Burkett and
 *      other unpaid contributors.
 * 5. The name of B. Scott Burkett may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY B. SCOTT BURKETT AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL B. SCOTT BURKETT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 ***************************************************************************** 
 $Header: /opt/home/staff/scottb/msqlexpire/RCS/notify.c,v 1.1 1996/07/06 16:05:50 scottb Exp scottb $
 ***************************************************************************** 
 $Log: notify.c,v $
 * Revision 1.1  1996/07/06  16:05:50  scottb
 * Initial revision
 *
 *****************************************************************************

 notify.c: Module that handles notification of record owners that a given
	   record has been removed from the database

 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "msql.h"

#include "msqlexpire.h"

static void SendRecord( FILE *stream );
static void SendFile(char *filename, FILE *stream);

void NotifyOwner( void )
{
	FILE *mail;
	char cmdbuf[80];

	/* Build command line for pipe */
	sprintf(cmdbuf, "/bin/mail -s \"%s\" %s", MAILSUBJECT, row[notify_field]);

	if((mail = popen(cmdbuf, "w")) == NULL) {
		perror("popen");
		exit(EXIT_FAILURE);
	}

	
	SendFile(MAILHEADER, mail);
	SendRecord(mail);
	SendFile(MAILFOOTER, mail);
	
	pclose(mail);
}

static void SendFile(char *filename, FILE *stream)
{
	FILE *f;
	char buf[100];

	if((f = fopen(filename, "r")) == NULL) {
		perror("fopen");
		return;
	}

	while(fgets(buf, 80, f))
		fputs(buf, stream);

	fclose(f);
}

static void SendRecord( FILE *stream )
{
	int cntr=0, numfields;
	m_field *currfield;
	
	numfields = msqlNumFields(result);

	while( cntr < numfields )
	{
		currfield = msqlFetchField(result);

		fprintf(stream, "%-15s: %s\n",
			currfield->name, row[cntr]);

		cntr++;
	}
	
	msqlFieldSeek(result, 0);
}
