/*
    conNExS.c  : link an MSQL db to a  NExS spreadsheet
                 version 0.6 Aug, 1st 1996
                 (C) 1996 Gian Paolo Ciceri
                 gp.ciceri@pn.itnet.it

    Usage: conNExS [-h host] database
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "msql.h"
#include "nexs.h"

#define VERSION "0.6"
#define MAX_QUERY_TIME 600

void usage(void);
void close_conn(int sock);
void query_dlg(int status, char *dialog_text);
void exit_fn(void);
void sq_dialog(void);
void check_for_nexs(void);
void alarm(int i);
void send_time2check(void);
void check_event(XEvent *event);

int main(int argc, char *argv[]);

Atom	xsConnectAtom;
Display *display;
Window nexs_window();
int status;  
int conn_sock;
const char *version= VERSION;
char *hostname = NULL;
char *dbname   = NULL;  
void usage(void)
{
  (void)fprintf(stderr,"\n\nUsage : conNExS [-h host] database \n\n");
  exit(-3);
}

void close_conn(int sock)
{
  /* close connection */
  msqlClose(sock);
  printf("\n\nsocket %d closed.\n", sock);
}

void query_dlg(int status, char *dialog_text)
{
  m_result *selected;         /* msql answer set structure    */
  m_field *sel_fields;        /* msql field structure         */
  m_row sel_row;              /* msql record structure        */
  int rowcount, colcount;     /* query answer set dimensions  */
  int result   = 0;           /* query result                 */
  int i, j;                   /* counters                     */
  int row;                    /* spreadsheet position, row    */
  int col;                    /* spreadsheet position, column */
  int ok  = 0;                /* auxiliary variable           */
  
  switch (status)
    {
    case NEXS_DIALOG_BUSY:
      
      printf("NExS Dialog box busy...\n");
      break;
      
    case NEXS_DIALOG_OK:
      
      /* get the current cursor position into the spreadsheet:
	 it seems that row starts from 1, but column starts from 0
	 */             

      ok = nexs_get_location(nexs_port, &row, &col);
      
      /* we're about to make a query, so please don't "alarm" us with new 
	 nexs client (this is required by send_time2check).
	 */

      alarm(MAX_QUERY_TIME);       /* a query has MAX_QUERY_TIME time */

      if ((result = msqlQuery(conn_sock, dialog_text))< 0)
	{
	  printf("\nERROR: Unable to get result from \"%s\"\n", dialog_text);
	  printf("\nReturn Code : \t %i\n", result);
	  nexs_display_message(nexs_port, "Unable to get result.");
	  alarm(1); 
	  break;
	}

      /* well, the query is O.K., so I've to get back the data to the
	 spreadsheet, and restore the alarm.
	 */

      alarm(1); 
      printf("NExS Query executed OK...\n");
      nexs_display_message(nexs_port, "Query ended."); 
      selected =  msqlStoreResult();
      rowcount =  msqlNumRows(selected);
      colcount =  msqlNumFields(selected);
      
      /* retrieves fieldnames */
      for (j = 0; j < colcount; j++)
	{ 
	  /* msqlFieldSeek(selected, j); */
	  sel_fields = msqlFetchField(selected);
	  nexs_store_label(nexs_port, row, col+1+j, sel_fields->name);
	}

      /* retrieves data (with attention to types): 
	 the values will be put at the right of the current cell 
	 */
      for (i = 0; i < rowcount; i++)
	{ 
	  msqlDataSeek(selected, i);
	  sel_row = msqlFetchRow(selected);
	  for (j = 0; j < colcount; j++)
	    {
	      msqlFieldSeek(selected, j);
	      sel_fields = msqlFetchField(selected);
	      if (sel_fields->type == CHAR_TYPE)
		nexs_store_label(nexs_port, (row+1+i), (col+1+j), sel_row[j]);
	      else
		nexs_store_number(nexs_port, (row+1+i), (col+1+j), atof(sel_row[j]));
	    }
	}
      
      /* now I can free the query answer set and exit */
      msqlFreeResult(selected);
      break;
      
    case NEXS_DIALOG_CANCELED:
      
      printf("NExS Dialog canceled...\n");
      break;
      
    }
}

void sq_dialog(void)
{
  /* the default query is contained in the current cell */
  char *query = NULL;
  int row, col, ok;
  ok = nexs_get_location(nexs_port, &row, &col);
  ok = nexs_get_string(nexs_port, row, col, &query); 
  nexs_dialog(nexs_port, "enter your SQL query", query, query_dlg);
  free(query);
}

void exit_fn(void)
{
  /* close connection to NExS */
  nexs_close_connection(nexs_port);

  /* close connection to msql */
  close_conn(conn_sock);
  exit(0);    
}

void check_for_nexs(void)
     /*
	Checks for a new nexs "client".  A new client is identified by the
	fact that it owns the xsConnectAtom and its window ID is different
	from any of the currently active ports.
	*/
{
  Window w;
  int portID, i;
  long menu;    
  if ((w = XGetSelectionOwner(display, xsConnectAtom)) != None)
    {
      for (i=1; i<=MAX_PORTS; i++)
	if (w == nexs_window(i)) return;
      portID = nexs_establish_connection("conNExS", 0);
      if (portID)
	{
	  menu = nexs_create_menu(portID, dbname);
	  nexs_create_button(portID, menu, "Send Query...", sq_dialog, 0);   
	  nexs_create_button(portID, menu, "Drop Server", exit_fn, 0); 
	  /* N.B.: in a callback, the port value is stored in nexs_port 
	     (=> don't use portID) */
	}
    }
}



void send_time2check(void)
     /*
	Send a ClientMessage event to this process once every second which
	says its time to look and see if any new copies of nexs have come
	up which need to be served.
	*/
{
  XClientMessageEvent cm_event;
  cm_event.type = ClientMessage;
  cm_event.display = display;
  cm_event.window = nexs_window(0);	        /* returns client window */
  cm_event.message_type = xsConnectAtom;	/* irrelevant */
  cm_event.format = 32;
  XSendEvent(display, cm_event.window, False, None, (XEvent *) &cm_event);
  XFlush(display);
  signal(SIGALRM, (void *)send_time2check );  /* set up to check again */
  alarm(1);	                              /* in 1 seconds */
}





void check_event(XEvent *event)
{
  if (event->type == ClientMessage &&
      event->xclient.message_type == xsConnectAtom)
    check_for_nexs();
}




/* here's the  beef */

int main(int argc, char *argv[])
{
  int conn_db;
  
  /* Step 0: parse arguments     */
  switch( argc )
    {
    case 2:
      hostname = (char *)getenv("HOSTNAME");
      dbname   = argv[1];
      break;
    case 4:
      if (!strcmp(argv[1],"-h"))
	{
	  hostname = argv[2];
	  dbname   = argv[3];
	  break;
        }
      usage();
    default:
      usage();
    }
  
  /* Step 1: get connection to msql     */
  
  if ((conn_sock = msqlConnect(hostname)) < 0)
    {
      printf("ERROR : %s\n", msqlErrMsg);
      exit(1);
    }
  printf("\n - conNExS %s - \n", version);
  printf("Connected to Server: %s\t socket %d open", hostname, conn_sock);  
  if ((conn_db = msqlSelectDB(conn_sock, dbname))< 0)
    {
      printf("\nERROR: Unable to connect to DB: '%s'\t", dbname);
      printf("\nReturn Code : \t %i\n", conn_db);
      return 0;
    }
  printf("\nDB selected        : %s", dbname);
  printf("\n");
  
  /* Step 2: get connection to NExS        */
  
  if ((display = XOpenDisplay("")) == NULL)
    {
      fprintf(stderr, "Could not open display!\n");
      exit(0);
    }
  nexs_connect_init(display);
  xsConnectAtom = XInternAtom(display, "XS_Connect", False);
  send_time2check(); 
  nexs_dispatcher(check_event);  
  return(0);
}













