#!/usr/local/bin/perl
#
# Creates a database and then fills it with some
# tables and various examples.
#
# Version 1.00 Dirk.vanGulik@jrc.it
# http://ewse.ceo.org http://me-www.jrc.it/~dirkx
#
#
die "usage: $0 [[database-host] [database]]\n" 
	if ($#ARV > 1);

# Get most of the values below form the config.h file
#
include("config.h");

# what box are we to use

$host=shift || "$DBHOST";

# name of the mSQL database, 

$dbase=shift || "$DBASE";

# Names of the tables and fields

$passwd_table="$PWTABLE";
$group_table="$GTABLE";

$user_field="$UNAME";
$passwd_field="$PNAME";
$group_field="$GNAME";

# A file, 
#   user:password[:group[group]]
# 
# If no file is given, some silly default is
# used.
$user_file='';

# Set if the values in the passwd file are encrypted.
$passwords_are_not_encrypted=1;

# No user servicable bits beyound this line :-)
use Msql;

# Do we have that database ?
($dbh = Msql->Connect($host))
	or die "Please start a mSQL server on $host first\n";

($dbh->SelectDB($dbase)) 
	or die "Please create a mSQL table, 'msqladmin create $dbase'\n";

# Are the tables there, or shall we create them ?

$dbases=join(' ',$dbh->ListTables);

if ($dbases !~ m/$passwd_table/) {
	($sth = Msql::Query( $dbh, 
		qq|
		create table $passwd_table (
			$user_field char(16) primary key,
			$passwd_field char(16)
			)
		|
		)) or die "Could not create $host.$dbase.$passwd_table $Msql::db_errstr";

	print STDERR "No Table $dbase.$passwd_table. Created One\n";
	};	

if ($dbases !~ m/$group_table/) {
	($sth = Msql::Query( $dbh, 
		qq|
		create table $group_table (
			$user_field char(16),
			$group_field char(16)
			)
		| )) or die "Could not create $host.$dbase.$group_table $Msql::db_errstr";

	print STDERR "No Table $dbase.$group_table. Created One\n";
	};	

# done with the databases now.
undef $dbh;

# The technique below is a wee bit stupid... but this
# is a demo
if ($user_file) {
	print STDERR "Reading the file\n";
	open(FH,$user_file) or die("Could not read $user_file $@");
	@lines=<FH>;
	close(FH);
	} else {
	print STDERR "Generating a few users\n";
	# Generate a silly one
	@users=('aap','noot','mies','wim','zus','jet');
	@group=($A,$B);
	foreach $i (0..$#users) {
		$l="$users[$i]:pw_$users[$i]:";  # anmwzj
		$l.="$group[0]," if (($i % 2)); # 010101
		$l.="$group[1]," if (($i % 3)); # 011011
		$l =~ s/[:|,]$//;
		$l.="\n";
		push @lines,$l;
		};
	};

print STDERR "\nFeeding in the names\n";

foreach $l (@lines) {
	chop $l; # get rid of the cr
	@a=();@g=();
	@a=split(/:/,$l) or die "$l is not a valid line";
	$user=shift(@a) or die "No user in $l";
	$passwd=shift(@a) or die "No passwd in $l";

	&add_user($user,$passwd,$passwords_are_not_encrypted)
		or die "Could not add user: $@\n";

	if (@g=split(/,/,$a[0])) {
		foreach $group (@g) {
			&add_group($user,$group)
				or die "Could not add group: $@\n";
			};
		};
	};

print STDERR "OK, databases are ready";
exit;

sub add_user {
	local ($userid,$passwd,$encode)=@_;
	local $dbh;
	
	$passwd=&crypt_passwd($passwd)
		if ($encode);

	if (!($dbh = Msql->Connect($host))) {
		$@="Could not connect to $host $Msql::db_errstr";
		warn $@;
		return undef;
		};

	if (!($dbh->SelectDB($dbase))) {
		$@="Could not select $dbase $Msql::db_errstr";
		warn $@;
		return undef;
		};

	# Do not Check if the name is already there :-)
	local $q="delete from $passwd_table where $user_field='$user'";

	if (!($sth = Msql::Query( $dbh, $q ) )) {
		# Hapily ignore errors		
		};

	local $q="insert into $passwd_table 
			($user_field,$passwd_field) 
			values('$user','$passwd')
		";

	if (!($sth = Msql::Query( $dbh, $q ) )) {
		$@="Could not update mSQL table: query=$q $Msql::db_errstr";
		warn $@;
		return undef;
		};

	# release memory and close connection
	undef $dbh;

	return def;
	};
	

sub add_group {
	local ($userid,$group)=@_;
	local $dbh;
	
	if (!($dbh = Msql->Connect($host))) {
		$@="Could not connect to $host $Msql::db_errstr";
		return undef;
		};

	if (!($dbh->SelectDB($dbase))) {
		$@="Could not select $dbase $Msql::db_errstr";
		return undef;
		};

	local $q="insert into $group_table 
		($user_field,$group_field) 
		values ('$user', '$group')
		";

	if (!($sth = Msql::Query( $dbh, $q ) )) {
		$@="Could not update mSQL table: query=$q $Msql::db_errstr";
		return undef;
		};

	# release memory and close connection
	return def;
	};
	

sub to64 {
        local ($v,$n)=@_; local $s,$a;
        $a="./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        while (--$n >=0 ) {
                $s.=substr($a,($v % 64),1);
                $v>>=6;
                };
        return $s;
        };
 
sub crypt_passwd {
        local ($passwd,$salt)=@_;
        if (!($salt)) {
                srand(time);
                $salt=to64(rand(64*64),2);
                };
        return crypt($passwd,$salt);
        };
 
sub include { 
	local ($file)=@_;
	open(FH,$file) or die "Could not open include file $file";
	while(<FH>) { 
		chop;
		eval "\$$1='$2'" 
		or die "Did not understand include file $@"
			if m/\#define\s+(\S+)\s+(\S+)/;
		};
	close(FH); 
	return def;
	};
