/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: msqlacc.c,v $
    Module Description:	Virtual interface to msql database engine

Description: 

Created on   26 Apr 1995    By damian

Edit History:

	$Log: msqlacc.c,v $
 * Revision 2.2  1996/07/03  14:48:37  damian
 * add logging code
 *
 * Revision 2.1  1996/01/04  11:44:51  V
 * Version 2
 * change seperator arg to int
 *
 * Revision 1.1  1995/12/21  18:09:08  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: msqlacc.c,v 2.2 1996/07/03 14:48:37 damian Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */

/*
 * system header files 
*/
#include <sys/types.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>

#ifdef Vsunos40
#include "Vansi.h"
#endif

/*
 * third party headers ie, X, informix, ctree 
*/

/*
 * project header files 
*/
#include "Vlib.h"
#include "msql.h"
#include "Vdb.h"

/*
 * local header files 
*/

/*
 * local defines 
*/

/*
 * local typedefs 
*/

/*
 * static function declarations 
*/

/*
 * static local variables 
*/

/*
 * exported objects/variables (non-static) 
*/

/*
 * static functions 
*/

/*
 * non static functions 
*/

m_result    *res = NULL;
int         rpos = 0;
m_row       row = NULL;
int         nrows = 0;
int         nfields = 0;

struct dbasenames {
    char    name[32];
} dbnames[64];

#ifdef VANSI_1
int
VdbNumRows(VdbHandle handle)
#else
int
VdbNumRows(handle)
VdbHandle handle;
#endif
{
    return nrows;
}

/* 
 * connect to database engine on specified host
*/
#ifdef VANSI_1
VdbHandle
VdbConnect(char *host)
#else
VdbHandle
VdbConnect(host)
char    *host;
#endif
{
    int     handle;
    
    errno = 0;

    if ( (handle = msqlConnect(host)) < 0 )
	sprintf(Vusrmsg, "Couldn't connect to engine! - %s [%s]\n", 
		msqlErrMsg, Vstrerror(errno));

    return (VdbHandle) handle;
}

/*
 * select a database
*/
#ifdef VANSI_1
int
VdbSelect(VdbHandle handle, char *db)
#else
int
VdbSelect(handle, db)
VdbHandle     handle;
char    *db;
#endif
{
    int     err;
    
    errno = 0;

    if ( (err = msqlSelectDB((int)handle,db)) < 0 ) {
	sprintf(Vusrmsg, "Couldn't select database [%s]! - %s [%s]\n", 
		db, msqlErrMsg, Vstrerror(errno));

	dbnames[handle].name[0] = '\0';

    } else {
	strcpy(dbnames[handle].name, db);
    }

    return err;

}

static char     *msql_logfile = NULL;
static int      do_logging = FALSE;

/*
 * perform a database query
*/
#ifdef VANSI_1
int
VdbQuery(VdbHandle handle, char *query)
#else
int
VdbQuery(handle, query)
VdbHandle     handle;
char    *query;
#endif
{
    
    int     err;
    DfltsInfo   di;
    char    *val;
    FILE    *lfp;

    errno = 0;

    /* log the query if logging is enabled */

    if ( msql_logfile == NULL ) {

	memset(&di, 0, sizeof(di));
	di.group = "msql";
	di.tag = "log_file";
	di.base = ANY_DFLT_SET;

	/* if the logfile isn't specified then set logfile to "" so we don't
	   keep trying to get the tag's value */

	if ((val = DfltGetString(&di)) == NULL)
	    msql_logfile = "";
	else
	    msql_logfile = CopyString(val);

	di.tag = "log_queries";
	di.base = ANY_DFLT_SET;
	do_logging = DfltGetBool(&di);
    }

    if ( msql_logfile && msql_logfile[0] ) {

	if ( do_logging == TRUE ) {
	    if ((lfp = fopen(msql_logfile, "a")) == NULL)
		syslog(LOG_ERR, "couldn't open msql logfile %s - %m", 
		       msql_logfile);
	    else {
		fprintf(lfp, "%s: %s\n", dbnames[handle].name, query);
		fflush(lfp);
		fclose(lfp);
	    }
	}
    }

    /*-- do the query */
    if ( (err = msqlQuery((int)handle,query)) < 0 ) {
	sprintf(Vusrmsg, "Query failed! - %s [%s]\n", 
		msqlErrMsg, Vstrerror(errno));
	return err;
    }

    if ( strncasecmp(query,"select", 6) == 0) {
	if ( res != NULL )
	    msqlFreeResult(res);

	/*-- store the result so it isn't overwritten */
	res = msqlStoreResult();

	nrows = msqlNumRows(res);

	nfields = msqlNumFields(res);
    }

    return 0;

}

/*
 * close the connection to the database engine
*/
#ifdef VANSI_1
int
VdbClose(VdbHandle handle)
#else
int
VdbClose(handle)
VdbHandle    handle;
#endif
{
    msqlClose((int)handle);

    return 0;
}

/*
 * 
*/
int
VdbFetchRow(VdbHandle handle, char *fldv[], int *num)
{
    int      i;

    if ( *num > nfields )
	*num = nfields;

    if ((row=msqlFetchRow(res)) == NULL) 
	return -1;

    /*-- print each field into the buffer */
    for (i = 0; i < *num; i++) 
    {
	fldv[i] = row[i];
    }

    return 0;
}

/*
 * get pointers to the first record's data values
*/
int
VdbFirstRec(VdbHandle handle, char *fldv[], int *num)
{

    msqlDataSeek(res,(rpos = 0));

    return VdbFetchRow(handle, fldv, num);

}

/*
 * move the result record pointer to the next result
 * and get the values therein
*/
int
VdbNextRec(VdbHandle handle, char *fldv[], int *num)
{
    msqlDataSeek(res,++rpos);

    return VdbFetchRow(handle, fldv, num);
}

/*
 * move the result record pointer to the previous result
 * and get the values therein
*/
int
VdbPrevRec(VdbHandle handle, char *fldv[], int *num)
{
    if ( rpos > 0) {
	msqlDataSeek(res,--rpos);

	return VdbFetchRow(handle, fldv, num);
    } else
	return -1;

}

/*
 * format the result of a query into a list of strings
 * each field is delimited by '^' character
*/
#ifdef VANSI_1
StringList  
VdbResultSL(VdbHandle handle, int sep)
#else
StringList  
VdbResultSL(handle, sep)
VdbHandle handle;
int     sep;
#endif
{
    StringList   sl = NULL;
    char         rbuf[4096], *p;
    int          i, num = 1;

    /*-- while there are more rows in the result */

    while ((row=msqlFetchRow(res)) != NULL) 
    {
	if ( sl == NULL) {
	    sl = CreateStringList(1);
	}

	p = rbuf;

	/*-- print each field into the buffer */
	for (i = 0; i < nfields; i++) 
	{
	    sprintf( p, "%s%c", row[i], sep & 0xff );

	    p = EndOfString(p) +1;
	}

	/*-- extend the StringList to accomodate the new row
	  (has no effect for the first row) */
	sl = ExtendStringList(sl, &num);

	/*-- and copy the buffer into the StringList */
	sl[num - 1] = CopyString(rbuf);

	num++;

    }

    return sl;
}


/*
 * format the result of a query into a list of strings
 * each field is delimited by specified seperator character
*/
#ifdef VANSI_1
LLlist  *
VdbResultLL(VdbHandle handle, int sep)
#else
LLlist  *
VdbResultLL(handle, sep)
VdbHandle handle;
int     sep;
#endif
{
    LLlist       *rl;
    char         rbuf[4096], *p;
    int          i;

    rl = LLcreate(NULL,NULL,NULL,0);

    /*-- while there are more rows in the result */

    while ((row=msqlFetchRow(res)) != NULL) 
    {
	p = rbuf;

	/*-- print each field into the buffer */
	for (i = 0; i < nfields; i++) 
	{
	    sprintf( p, "%s%c", row[i], sep & 0xff );

	    p = EndOfString(p);
	}

	/*-- and copy the buffer into the StringList */
	LLappend(rl,(void *) CopyString(rbuf));

    }

    return rl;
}

