/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: Vllist.h,v $
    Module Description:	  linked list header file


Description: 


Edit History:

	$Log: Vllist.h,v $
 * Revision 1.1  1995/01/19  11:32:28  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) 
static char moduleRCSid[] = "@(#) $Id: Vllist.h,v 1.1 1995/01/19 11:32:28 V Exp $";
*/

#ifndef VLLIST_H
#define VLLIST_H


#include <sys/types.h>


#define LLDESTROY_ALL   1

/* access macros */

#define LLUserPtr(a)	((a)->datap) /* access user pointer member */

/* llist will call these functionsto get and free memory from the
 * heap. A user can replace these to provide a single point of
 * error checking rather than having to check every Add/Create
 */

#ifdef VANSI_1
typedef void* (*LLmallocFunc)(size_t n);
typedef void (*LLfreeFunc)(void *d);
#else
typedef void* (*LLmallocFunc)();
typedef void (*LLfreeFunc)();
#endif

extern LLmallocFunc LLmalloc;
extern LLfreeFunc LLfree;

/*
 * generic link list system (but modified to make tail of list point
 * to head of list. The head of a list is never used to store data,
 * only to keep track of first real item and last item.
 */

struct llitem_type;

typedef struct llitem_type {
	void *datap;    /* data ptr (NULL if this is the list head) */
	struct llitem_type* next;
	struct llitem_type* prev;
} LLITEM, *LLITEMPTR;

struct LLnode_type {
	void 		*data;	/*-- data ptr  */
	struct LLnode_type*	next;	/*-- next node on list  */
	struct LLnode_type*	prev;	/*-- previous node in list  */
} LLnode_type;

typedef struct LLnode_type LLnode;

typedef struct _LLlist {
    int		(*comp)();		/*-- compare function */
    int		(*hash)();		/*--  hash function */
    void	(*dest)();		/*--  destroy function */
    LLnode	*head;		/*-- head of list  */
    LLnode	*tail;		/*-- tail of list */
    LLnode	*current;	/*-- used during list scanning  */
    int		count;		/*-- number of items on the list  */
    int		numhash;	/*-- number of hash nodes in array */
    LLnode	*nodes[1];/*-- array of pointers to hashed nodes  */
} LLlist;

#ifdef VANSI_1
typedef int (*LLActFunc)(void *userdata);
#else
typedef int (*LLActFunc)();
#endif


/* function prototypes */

/*  function set using LLITEM & LLLITEMPTR */
extern LLITEMPTR LLCreate();

#ifdef  VANSI_1
extern void LLInitHead(LLITEMPTR head);
extern LLITEMPTR LLAdd(LLITEMPTR after,void *data);
extern LLITEMPTR LLAddEnd(LLITEMPTR head,void *data);
extern void LLDelete(LLITEMPTR item);
extern void *LLScan(LLITEMPTR *cpos);
extern void *LLRScan(LLITEMPTR *cpos);
extern int LLAction(LLITEMPTR lptr, LLActFunc actfunc);
extern void LLDestroy(LLITEMPTR head, int all);
extern int LLCount(LLITEMPTR head );
extern void *LLGetNth(LLITEMPTR head, int n );
extern void LLFreeBuff(LLITEMPTR head );
extern int  DumpLLitemPtr(LLITEMPTR head );
#else
extern void LLInitHead();
extern LLITEMPTR LLAdd();
extern LLITEMPTR LLAddEnd();
extern void LLDelete();
extern void *LLScan();
extern void *LLRScan();
extern int LLAction();
extern void LLDestroy();
extern int LLCount();
extern void *LLGetNth();
extern void LLFreeBuff();
extern int  DumpLLitemPtr();
#endif


/* function set using LLnode LLlist */

extern LLlist *LLcreate( int hash(), int comp(), void dest(), int );

#ifdef  VANSI_1
extern void LLinitScan(LLlist *list, int direction);
extern LLnode *LLinsert(LLlist *list, LLnode *after, void *data);
extern LLnode *LLinsertB(LLlist *list, LLnode *before, void *data);
extern LLnode *LLadd(LLlist *list, void *data);
extern LLnode *LLappend(LLlist *list, void *data);
extern LLnode *LLpush(LLlist *list, void *data );
extern void *LLpop(LLlist *list);
extern void LLdelete(LLlist *list, LLnode *node);
extern void *LLscan(LLlist *list);
extern void *LLrScan(LLlist *list);
extern int LLaction(LLlist *list, LLActFunc actfunc);
extern void LLdestroy(LLlist *list);
extern int LLcount(LLlist *list );
extern void *LLgetNth(LLlist *list, int n );
extern void LLfreeBuff(LLlist *list );
extern int  LLdumpList(LLlist *list );
extern void *LLfind(LLlist *list, void *udp, int val);
extern int LLmerge(LLlist *list, LLlist *list2, int val);
extern LLnode *LLfindNode(LLlist *list, void *udp, int val);
extern int LLremove(LLlist *list, void *udp, int val);
extern LLnode *LLhashNode( LLlist *list, void *udp);
extern void LLclear(LLlist *list);
#else
extern void LLinitHead();
extern LLnode * LLadd();
extern LLnode * LLappend();
extern LLnode *LLpush();
extern void *LLpop();
extern void LLdelete();
extern void *LLscan();
extern void *LLrScan();
extern int LLaction();
extern void LLdestroy();
extern int LLcount();
extern void *LLgetNth();
extern void LLfreeBuff();
extern int  LLdumpList();
extern void *LLfind();
extern int LLmerge();
extern LLnode *LLfindNode();
extern int LLremove();
extern LLnode *LLhashNode();
extern void LLclear();
#endif


/* 
  alternative list library 
   -- no hashing  
   -- no finding 
*/

/* node in a doubly linked list */
typedef struct llist_node
{
	struct llist_node *next;	/* next node */
	struct llist_node *prev;	/* prev node */
	void *data;		    /* data area associated with this node */
	int size;	     /* size of the data area - zero if is a light-
	                             * weight node */
} LLIST_NODE;

/* header of a doubly linked list */
typedef struct
{
	LLIST_NODE *head;	/* first node */
	LLIST_NODE *tail;	/* last node */
	int count;			/* number of nodes in list */
} LLIST_HDR;


#ifdef VANSI_1
extern LLIST_NODE *llist_append(LLIST_HDR *, int);
extern LLIST_NODE *llist_prepend(LLIST_HDR *, int);
extern LLIST_NODE *llist_insert_b(LLIST_HDR *, LLIST_NODE *, int);
extern LLIST_NODE *llist_insert_a(LLIST_HDR *, LLIST_NODE *, int);
extern void llist_insert_node(LLIST_HDR *, LLIST_NODE *, LLIST_NODE *);
extern void llist_delete(LLIST_HDR *, LLIST_NODE *);
extern void llist_extract(LLIST_HDR *, LLIST_NODE *);
extern void llist_clear(LLIST_HDR *);
extern void llist_concat(LLIST_HDR *, LLIST_HDR *);
extern LLIST_NODE *llist_nth_node(LLIST_HDR *, int);
#else
extern LLIST_NODE *llist_append();
extern LLIST_NODE *llist_prepend();
extern LLIST_NODE *llist_insert_b();
extern LLIST_NODE *llist_insert_a();
extern void llist_insert_node();
extern void llist_delete();
extern void llist_extract();
extern void llist_clear();
extern void llist_concat();
extern LLIST_NODE *llist_nth_node();
#endif

#endif /* VLLIST_H */
