/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: StringList.c,v $
    Module Description:	  StringList handling functions

Description:


Edit History:

	$Log: StringList.c,v $
 * Revision 2.1  1996/01/04  12:36:58  V
 * Version 2
 *
 * Revision 1.3  1995/12/21  18:05:50  V
 * latest revision
 *
 * Revision 1.2  1995/01/19  10:44:31  V
 * moved utility functions to StrListUtils.c
 *
 * Revision 1.1  1995/01/09  18:21:23  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: StringList.c,v 2.1 1996/01/04 12:36:58 V Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */


/*
 *   system header files
 */
#include <stdio.h>
#include <memory.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/*
 *  X / Informix (sub system) header files
 */

/*
 *   public project/department header files
 */


#include "Vlib.h"

/*
 * local library header files
 */

/*
 * Magic number used when checking if we have a list or not
 */
#define StringListMagicNumber 0x1234

/*
 * This structure is 'hidden' as the -1'th element in the list returned.
 * It is needed so we know how many string ptrs in list to attempt to
 * free up.
 */
typedef struct _StringListInfo
  {
    int num;			/* number of elements */
    int magic;			/* magic number */
  }

StringListInfo;

/*
 * Simple create/destroy for list of string ptrs.
*/

/*++ ***************  function  CreateStringList ****************/
/*
	Purpose:
	Malloc an array for num+1 string ptrs. Set all string ptrs to NULL.
	The reason for num+1, is so always a NULL ptr at the end.

	Globals changed: none

	Parameters:
	int      num        == size of string list to create
	                       (if < 1, set to 1)
	Return Values:
	StringList      list

	                 Returns ptr to array of string ptrs.
	                 Cannot return NULL as program
			 will be aborted on memory failure.

	Dependencies:
	Malloc

	History:
	28/10/92         dh         created
*/
/************************************************************************ ++**/

#ifdef VANSI_1
StringList 
CreateStringList (int num)
#else
StringList 
CreateStringList (num)
     int num;
#endif
{
  StringList list;
  StringListInfo *si;

  if (num < 1)
    num = 1;
  else
    num++;			/* for the terminating NULL */

  /*-- allocate space for the StringList's info */
  si = Malloc (sizeof (StringListInfo));
  si->num = num;
  si->magic = StringListMagicNumber;

  /*-- allocate space for the StringList itself */
  list = Malloc ((num + 1) * sizeof (char *));
  /*
     * Porting Note:
     * that calloc would not save us from setting each element
     * to NULL. Calloc zeros memory. The NULL ptr may not be zero after
     * the compiler gets it due to strange hardware out there.
     * Also assumes sizeof(char *) == sizeof (StringListInfo *).
     */

  /*-- the first element in the string list points to the info structure
      which is hidden by returning the address of the second element */

  list[0] = (char *) si;
  list = &list[1];		/* hide the info */

  while (num--)
    list[num] = NULL;
  return list;
}


/*++ ***************  function  DestroyStringList ****************/
/*
	Purpose:
	Frees up a string list previously created by CreateStringList. In
	addition it Free()'s any non-NULL ptrs in the list.
	
	Will abort program if list ptr passed was not a string list.

	Globals changed:  none

	Parameters:
	StringList  list    == ptr to list  (if NULL then harmlessly returns)

	Return Values:  void

	Dependencies:  Free()

	History:
	28/10/92         dh         created
*/
/************************************************************************ ++**/

#ifdef VANSI_1
void 
DestroyStringList (StringList list)
#else
void 
DestroyStringList (list)
     StringList list;
#endif
{
  StringListInfo *si;

  if (!list)
    return;

  /*-- get the string list info block */
  si = (StringListInfo *) list[-1];
  if (si->magic != StringListMagicNumber)
      return;

  si->magic = 0;		/* stop double destroys */

  /*-- free all strings in the list */
  while (si->num--)
    Free (list[si->num]);
  Free (si);
  Free (list - 1);
}

/*++ ***************  function  ExtendStringList ****************/
/*
	Purpose:      Extend number of elements in a string list
	
	Globals changed:  none

	Parameters:
	StringList  list    == ptr to string list returned from
	                       CreateStringList()
	int         *newnum == ptr to the number of elements required
	                       (not including the NULL terminator)

	Return Values:
	StringList      list  == extended stringlist

	New count of elements in list (excluding the terminating NULL) is
	placed in newnum.
	if the number of elements in the list exceeds the number asked for,
	no action is taken.

	Dependencies:
	Realloc

	History:
	28/10/92         dh         created
*/
/************************************************************************ ++**/

#ifdef VANSI_1
StringList 
ExtendStringList (StringList list, int *newnum)
#else
StringList 
ExtendStringList (list, newnum)
     StringList list;
     int *newnum;
#endif
{
  StringListInfo *si;
  StringList newlist;
  int i;

  /* Check args */
  if (newnum == NULL)
    {
      return list;
    }

  /* Create a new list if not one already there */
  if (list == NULL)
    {
      /* Create a list and return it */
      newlist = CreateStringList (*newnum);
      return newlist;
    }

  /* Check we have a stringlist */
  si = (StringListInfo *) list[-1];
  if (si->magic != StringListMagicNumber)
      return NULL;
  
  /* Is the list already long enough? */
  if (*newnum < si->num)
    {
      /* Set newnum to the actual length of the list */
      *newnum = si->num - 1;	/* Take account of NULL terminator */
      return list;
    }

  /* Get space for new list */
  newlist = (StringList) Realloc (&list[-1], (*newnum + 2) * sizeof (char *));

  /* Hide info record */
  newlist = &newlist[1];

  /* Zero out new pointers */
  for (i = si->num; i <= *newnum; i++)
    {
      newlist[i] = NULL;
    }

  /* Update info record with new length */
  si->num = *newnum + 1;	/* +1 for NULL terminator */

  return (newlist);
}

/*++ ***************  function  CountStringList ****************/
/*
	Purpose:      return number of elements in a string list
	
	Globals changed:  none

	Parameters:
	StringList      list     == list to count is a Stringlist pointer
	                            returned from CreateStringList()

	Return Values:  int
	n == Count of elements in list (excluding the terminating NULL).
	     ie. 	it returns the num passed to CreateStringList().

	Dependencies:  none

	History:
	28/10/92         dh         created
*/
/************************************************************************ ++**/

#ifdef VANSI_1
int 
CountStringList (StringList list)
#else
int 
CountStringList (list)
     StringList list;
#endif
{
  StringListInfo *si;

  if (list == NULL)
    return 0;

  /*-- get the string list info block handle */
  si = (StringListInfo *) list[-1];
  if (si->magic != StringListMagicNumber)
      return -1;

  /*-- return the number in the info block */
  return (si->num - 1);
}
