/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: StrCase.c,v $
    Module Description:	string case conversions

Description: 

Edit History:

	$Log: StrCase.c,v $
 * Revision 1.1  1995/01/09  18:21:23  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: StrCase.c,v 1.1 1995/01/09 18:21:23 V Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */

/********************* system header files **********************/

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

#include "Vlib.h"

/********************** non static functions **********************/



/*++ ***************  function UppStr ****************

	Purpose:
	convert a string to uppercase  
	
	Globals changed:
	_uppstr static char pointer

	Parameters:
	char * str   pointer to string to convert

	Return Values:  static char *   converted string

	Dependencies:


***************************************************************** ++*/
static char *_uppstr = NULL;

char *UpperStr( str )
char *str;
{
    char *p;

    if (str == NULL)
	return NULL;

    if (_uppstr != NULL)
	Free( _uppstr );

    _uppstr = CopyString( str );

    p = _uppstr;

    while( *p ) {
	if ( islower( *p ) )
	    *p = toupper( *p );
	p++;
    }
    return _uppstr;
}


/*++
 *  Name:       UppString
 *
 *  Purpose:	upper case a string in situ
 *
 *  Globals changed: none
 *
 *  Parameter Description:
 *	char	*str	string to upper case
 *
 *  Return Values: void
 *
 *  Dependencies: UpperStr
 *
 *  Notes:
 *
++**/

#ifdef VANSI_1
void
UppString( char *str )
#else
void
UppString( str )
char		*str;
#endif
{
    char	*s;

    if (str == NULL)
	return ;

    s = UpperStr( str );

    strcpy( str, s);

}

/*++ ***************  function LowerStr ****************

	Purpose:
	convert a string to lower case  
	
	Globals changed:
	_lowstr static char pointer

	Parameters:
	char * str   pointer to string to convert

	Return Values:  static char *   converted string

	Dependencies:


***************************************************************** ++*/
static char *_lowstr = NULL;

char *LowerStr( str )
char *str;
{
    char *p;


    if (str == NULL)
	return NULL;

    if (_lowstr != NULL)
	Free( _lowstr );

    _lowstr = CopyString( str );

    p = _lowstr;

    while( *p ) {
	if ( isupper( *p ) )
	    *p = tolower( *p );
	p++;
    }
    return _lowstr;
}



/*++ ***************  function strcasestr **************

	Purpose:
	determine if str2 exists in str1, ignoring case
	
	Globals changed:

	Parameters:
	char * str1    host string
	char * str2    string to find

	Return Values:
	char *   pointer to occurance of str2 in str1

	Dependencies:


******************************************************************* ++*/
#ifdef VANSI_1
char *strcasestr( char *str1, char *str2 )
#else
char *strcasestr( str1, str2 )
char *str1;
char *str2;
#endif
{
    /*-- return a pointer to the first occurrance of str2 in str1,
       ignoring case */
    char *p, *t;

    p = str1;

    while ( ( *p ) ) {
	if ( toupper(*p) == toupper(str2[0]) ) {
	    t = str2;
	    while( *p && *t )
		if ( toupper(*p++) != toupper(*t++) ) 
		    break;
	    if (!*t)
		return p;
	} else
	    p++;
    }

    return NULL ;
}
