/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: DfltsPrint.c,v $
    Module Description:	print routines for defaults system

Description: 

Edit History:

	$Log: DfltsPrint.c,v $
 * Revision 1.1  1995/02/03  18:27:53  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: DfltsPrint.c,v 1.1 1995/02/03 18:27:53 V Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */

/*
 * system header files 
*/
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

/*
 * project header files 
*/
#include "Vlib.h"

/*
 * local header files 
*/
#include "DfltsP.h"

/*
 *   print a set of defaults
*/

static int curr_indent_level = 0;


#ifdef VANSI_1
int PrintTag( char *tag )
#else
int PrintTag( tag )
char *tag;
#endif
{
    char *val;
    DfltInfo    di;

    curr_indent_level += 2 ;

    Memset(di, 0, sizeof(di));

    di.tag = tag;
    di.default = "?";
    di.base = ANY_DFLT_SET;

    val = DfltGetString( &di );

    if (val) 
	if ( curr_indent_level > 0)
	    printf("%*s%s = %s\n", curr_indent_level, " ", tag, val );
	else
	    printf("%s = %s\n", tag, val );

    curr_indent_level -= 2 ;

    if ( strcmp( val, "?" ) == 0)
	return -1;
    else
	return 0;

}

#ifdef VANSI_1
int PrintGroup( char *group, char *tag )
#else
int PrintGroup( group, tag )
char *group;
char *tag;
#endif
{
    int retval = 0;
    char *grpstr;
    char *t, *next;

    grpstr = DfltGetGroup( NULL, group );

    if (!grpstr) 
	return -1;

    if ( curr_indent_level > 0 )
	printf("%*sGroup: %s\n", curr_indent_level, " ", group );
    else
	printf("Group: %s\n", group );

    t = grpstr;

    do {
	next = TerminateAtNextChar( t, "," );
	if (tag) {
	    if ( strcmp( t, tag ) == 0) {
		if (PrintTag( tag ) < 0) {
		    fprintf(stderr, "%s error printing tag %s\n",
			    ProgramName(), tag );
		    retval = -1;
		} 
		break ;
	    }
	} else
	    if (PrintTag( t ) < 0) {
		retval = -1;
		fprintf(stderr, "%s error printing group %s\n",
			ProgramName(), t );
	    }

    } while (t = next);

    return retval;

}

#ifdef VANSI_1
int PrintSet( char *set, char *group, char *tag )
#else
int PrintSet( set, group, tag )
char *set;
char *group;
char *tag;
#endif
{
    char *setstr;
    char newset[MAXPATHLEN];
    int retval = 0;
    struct stat stbuf;
    char buf[MAXPATHLEN];
    int setnum, i;
    char *t, *p, *str;
    StringList Slist;

    DfltSetCurrentSet( set );

    setstr = DfltGetSet( set );

    if (set)
	if ( curr_indent_level > 0 )
	    printf("%*sSet: %s  -- %s", curr_indent_level," ", set, setstr );
	else
	    printf("Set: %s  -- %s", set, setstr );

    setnum = CountWords( setstr );

    if ( !setstr || !( t = strchr( setstr, ',' )) ) {
	if (set)
	    printf( "(empty set)\n" );
	return 0;
    } else
	if (set)
	    printf("\n");

    Slist = CreateStringList( setnum );

    /*-- seperate list into a StringList */
    str = setstr;
    for( i = 0; i < setnum && str ; i++ ) {
	Slist[i] = str;
	str = TerminateAtNextChar( str, "," );
    }

    for( i = 0; i < setnum ; i++ ) {

	t = Slist[i];

	if (!t)
	    continue;

	DfltSetCurrentSet( set );

	if (set)
	    sprintf( buf, "%s/%s/%s", DfltGetBaseSet(), set, t );
	else
	    sprintf( buf, "%s/%s", DfltGetBaseSet(), t );

	if ( stat( buf, &stbuf) < 0) {
	    fprintf(stderr, "can't access set %s\n", buf );
	    continue;
	}

	if (( stbuf.st_mode & S_IFMT) == S_IFREG ) {
	    curr_indent_level +=2;
	    if (group) {
		p = strchr( t, '.' );
		*p = '\0';
		if ( strcmp( t, group ) == 0)
		    if (PrintGroup( t, tag ) < 0) {
			retval = -1;
			fprintf(stderr, "%s error printing group %s\n",
				ProgramName(), t );
		    }
	    } else
		if ( strstr( t, ".bak" ) == NULL )
		    if (PrintGroup( t, tag ) < 0) {
			retval = -1;
			fprintf(stderr, "%s error printing group %s\n",
				ProgramName(), t );
		    }
	    curr_indent_level -=2;		    
	} else {
	    if (set)
		sprintf( newset, "%s/%s", set, t );
	    else
		sprintf( newset, "%s", t );
	    curr_indent_level +=2;
	    if (PrintSet( newset, group, tag ) < 0) {
		fprintf(stderr, "%s error printing set %s\n",
			ProgramName(), t );
		retval = -1;
	    }
	    curr_indent_level -=2;
	}
    }

    DestroyStringList( Slist );

    Free(setstr);

    return retval;
}

