/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: DbgTrace.c,v $
    Module Description:	output debug tracing


Description:


Edit History:

	$Log: DbgTrace.c,v $
 * Revision 2.4  1996/07/03  14:45:16  damian
 * remove the newline after the asctime()
 *
 * Revision 2.3  1996/05/01  13:08:25  damian
 * fix syslog args in LTRACE()
 *
	Revision 2.2  1996/03/07 00:01:16  damian
	add ability to send LTRACE outout to syslog

 * Revision 2.1  1996/01/04  12:35:26  V
 * Version 2
 *
 * Revision 1.5  1995/12/21  18:04:51  V
 * latest revision
 *
 * Revision 1.4  1995/08/29  10:04:41  damian
 * changes for sunos
 *
 * Revision 1.3  1995/02/27  17:40:04  V
 * cleaned up unused warnings
 *
 * Revision 1.2  1995/01/20  18:34:02  V
 * add recovery mode functions
 *
 * Revision 1.1  1995/01/09  18:21:23  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: DbgTrace.c,v 2.4 1996/07/03 14:45:16 damian Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */

/*
 *   system header files
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>
#include <syslog.h>

#ifdef VANSI_1
#include <stdarg.h>
#else
#include <varargs.h>
#endif

/*
 *  X / Informix (sub system) header files
 */

/*
 *   public project/department header files
 */

#include "Vlib.h"


/*
 *  local application/library header files
 */


static BitMask ltrace_level = 0;/* current LTRACE level */
static BitMask debug_mode = 0;	/* current debug mode level */
static BitMask recover_mode = 0;/* if recovering and what level */

static int ST_window = 0;	/* number of lines in STRACE window */
static char *ST_pattern = NULL;	/* STRACE pattern to match */
static int ST_case = 0;		/* STRACE case sensitivity flag */
static int ST_Inupcase = 0;	/* indicate pattern is in upper case */
static LLlist *ST_list = NULL;	/* STRACE output window */
static int ST_Wcount = 0;	/* how many more lines to print */

static FILE *logfp = stderr;	/* alternate log output stream */
static int (*lfp)(char *) = NULL;	/* function pointer for logging */

int via_syslog = FALSE;

#ifdef VANSI_1
static void
PrintSTlist ()
#else
static void
PrintSTlist ()
#endif
{
  LLnode *node, *next;
  char *str;

  if (ST_list == NULL)
    return;

  node = ST_list->head;

  /*-- if there are strings in the window output list then print
      them */

  /*-- for each string in the list */
  while (node)
    {
      str = (char *) node->data;
      next = node->next;

      /*-- print the string */
      fprintf (stderr, "%s", str);

      /*-- free the memory occupied by the string */
      Free (str);

      LLdelete (ST_list, node);

      node = next;
    }

}

/*++ **********************  function SetLogFile *****************

  Purpose: set the output file stream for logging

  Return Values: int

**************************************************************** ++*/
#ifdef VANSI_1
void
SetLogFile(int fd)
#else
void
SetLogFile(fd)
int fd;
#endif
{
    if ( fd < 0) {
	fclose(logfp);
	logfp = stderr;
    } else {
	logfp = fdopen(fd, "w");
    }
}

/*++ **********************  function SetLogFunction *****************

  Purpose: set the output function to call  for logging

  Return Values: int

**************************************************************** ++*/
#ifdef VANSI_1
void
SetLogFunction(int (*fp)(char *))
#else
void
SetLogFunctions(fp)
int (*fp)(char *);
#endif
{
    lfp = fp;
}

/*++ **********************  function SetLtraceLevel ***************

	Purpose: set the ltrace level to a specific value

	Return Values: void

******************************************************************* ++*/
#ifdef VANSI_1
void
SetLtraceLevel (BitMask level)
#else
void
SetLtraceLevel (level)
     BitMask level;

#endif
{
  ltrace_level = level;
}

/*++ **********************  function AddLtraceLevel ***************

	Purpose:  add a new ltrace level into the existing level
	          ( bitwise OR )

	Return Values: void

******************************************************************* ++*/
#ifdef VANSI_1
void
AddLtraceLevel (BitMask level)
#else
void
AddLtraceLevel (level)
     BitMask level;

#endif
{
  ltrace_level |= level;
}

/*++ **********************  function LtraceLevel ***************

	Purpose:  determine the current ltrace level

	Return Values: BitMask

******************************************************************* ++*/
#ifdef VANSI_1
BitMask
LtraceLevel (void)
#else
BitMask
LtraceLevel ()
#endif
{
    return ltrace_level;
}

/*++ **********************  function SetStracePattern ***************

	Purpose:  set up the pattern for STRACE matching

	Return Values: void

******************************************************************* ++*/
#ifdef VANSI_1
void
SetStracePattern (char *pattern)
#else
void
SetStracePattern (pattern)
     char *pattern;

#endif
{
  if (ST_pattern != NULL)
    Free (ST_pattern);

  if (pattern != NULL)
    ST_pattern = CopyString (pattern);
  else
    ST_pattern = NULL;
}

/*++ **********************  function SetStraceWindow ***************

	Purpose:  set the STRACE output window to n lines

	Return Values: void

******************************************************************* ++*/
#ifdef VANSI_1
void
SetStraceWindow (int lines)
#else
void
SetStraceWindow (lines)
     int lines;

#endif
{

  ST_window = lines;

  /*-- delete any existing window */
  if (ST_list != NULL)
    {
      LLclear (ST_list);
    }
}

/*++ **********************  function SetStraceCase ***************

	Purpose:  set the STRACE case sensitivity flag

	Return Values: void

******************************************************************* ++*/
#ifdef VANSI_1
void
SetStraceCase (int strcase)
#else
void
SetStraceCase (strcase)
     int strcase;

#endif
{
  ST_case = strcase ? 1 : 0;
}


/*++ ***************  function  LTRACE ****************/
/*
	Purpose:     print a string to stderr if all bits in mask
	             parameter are turned on in debug trace object
	
	Globals changed: none

	Parameters:
	va_alist      ( variable argument list, starting with a mask
	                the remainder in printf format
			ie.  LTRACE( BitMask mask, char *fmt, parameters... ) )

	Return Values:   void

	Dependencies:
	DbgLevel()

	Notes:
	all of the bits in mask must be turned on to print the string, so
	you can have multiple-bit masks for better selection of output.

	Consider this;

	-- define some operation class bit positions
	#define VLT_CREATE   0x02
	#define VLT_ADD      0x04

	-- define some bit for an item
	#define VLT_PAGE     0x20

	now use;

	LTRACE( VLT_CREATE | VLT_PAGE, "... format string", args );

	to just see output about the creation of pages etc.

	if STRACE is turned on then any output string containing the STRACE
	pattern is output regardless of the bitmask

*/
/************************************************************************ ++**/

#ifdef VANSI_1
void
LTRACE (BitMask mask,...)
#else
void
LTRACE (mask, va_alist)
     BitMask mask;

     va_dcl

#endif
{
  va_list args;
  char *fmt, *p, buf[4096], *wkcpy;
  time_t    t;


#ifdef VANSI_1
  va_start (args, mask);
#else
  va_start (args);
#endif

  fmt = (char *) va_arg (args, char *);

  t = time((time_t *)NULL);

  buf[0] = '\0';
  p = &buf[0];

  if ( ltrace_level & VLT_PID ) {
      sprintf(p, "[%d] ", getpid());

      p = &buf[strlen(buf)];
  }

  if ( ltrace_level & VLT_TIME ) {
      sprintf(p, "%s", asctime(localtime(&t)) );
      
      p = &buf[strlen(buf)];

  }

  if (p > buf) {

      if (*(p -1) == '\n') {
	  *(p -1) = ' ';
      }
  }

  /*-- format the string into a buffer */
  vsprintf (p, fmt, args);

  /*-- if STRACE is not enabled process as normal */
  if (ST_pattern == NULL)
    {
	
      if ((mask & (ltrace_level & ~(VLT_TIME | VLT_PID)) ) == mask) {

	  if ( via_syslog == TRUE ) {
	      int    log_type = LOG_NOTICE;

	      switch(mask & 0x1c ) {
	      case VLT_INFO:
		  log_type = LOG_NOTICE;
		  break;
	      case VLT_WARN:
		  log_type = LOG_WARNING;
		  break;
	      case VLT_ERROR:
		  log_type = LOG_ERR;
		  break;
	      }
	      syslog( log_type, p);
	  } else if ( lfp != NULL)
	      lfp(buf);
	  else
	      fprintf (logfp, buf);
      }
    }
  else
    {
      /*-- otherwise process for strace */
      if (ST_list == NULL)
	ST_list = LLcreate (NULL, strcmp, free, 0);

      /*-- format the string into a buffer */
      vsprintf (buf, fmt, args);

      wkcpy = UpperStr (buf);

      /*-- if case sensitivity is not enabled then
	  uppercase format string */
      if (ST_case == 0)
	{
	  /*-- if the strace pattern has not yet been converted to
	      upper case then do it now */
	  if (ST_Inupcase == 0)
	    {
	      ST_Inupcase = 1;
	      UppString (ST_pattern);
	    }
	}
      /*-- if the strace pattern occurs in the formatted string then */
      if (strstr (wkcpy, ST_pattern) != NULL)
	{

	  if (ST_list->count > 0 && ST_window > 0)
	    /*-- print the previous n lines in the window */
	    PrintSTlist ();

	  /*-- reset the window count */
	  ST_Wcount = ST_window;

	  /*-- output the matching string */
	  if ( lfp != NULL)
	      lfp(buf);
	  else
	      fprintf (logfp, buf);

	}
      else
	{
	  /*-- if we have already seen the strace pattern and there are more
	      strings to print in the window then print this string anyway */

	  if (ST_Wcount > 0)
	    {

		if ( lfp != NULL)
		    lfp(buf);
		else
		    fprintf (logfp, buf);

	      ST_Wcount--;

	    }
	  else
	    {
	      /*-- save the string into the window list */
	      /*-- if the window is full then junk the earliest string */
	      if (ST_window > 0 && ST_list->count == ST_window)
		{

		  p = LLpop (ST_list);

		  Free (p);

		}
	      LLappend (ST_list, CopyString (buf));

	    }

	}

    }

  va_end (args);

}

/*++ **********************  function FTRACEON ***************

	Purpose:  turn on FTRACE debug tracing

	Return Values: void

******************************************************************* ++*/
#ifdef VANSI_1
void
FTRACEON (void)
#else
void
FTRACEON ()
#endif
{
  ltrace_level |= 0x01;
}

/*++ ****************  function  FTRACE *********************/
/*
    Purpose:        print a string to stderr if LSB in trace level
                    is set to 1

    Globals changed:  none

    Parameters:
    va_alist      ( variable argument list in printf format
                    ie.  FTRACE( char *fmt, parameters... ) )

    Return Values:  void

    Dependencies:

    History:
    3/11/92          dh          created
*/
/************************************************************************ ++**/

#ifdef VANSI_1
void
FTRACE (char *fmt,...)
#else
void
FTRACE (fmt, va_alist)
     char *fmt;

     va_dcl

#endif
{
  va_list args;


#ifdef VANSI_1
  va_start (args, fmt);
#else
  va_start (args);
#endif

  if (ltrace_level & 0x01)
    vfprintf (stderr, fmt, args);

  va_end (args);

  return;

}


/*++ **********************  function AddDebugMode ***************

	Purpose: add a mode into the existing debug level

	Return Values:void

******************************************************************* ++*/
#ifdef VANSI_1
void
AddDebugMode (BitMask mode)
#else
void
AddDebugMode (mode)
     BitMask mode;

#endif
{
  debug_mode |= mode;
}

/*++ **********************  function SetDebugMode ***************

	Purpose: set the debug mode to a specific value

	Return Values:void

******************************************************************* ++*/
#ifdef VANSI_1
void
SetDebugMode (BitMask mode)
#else
void
SetDebugMode (mode)
     BitMask mode;

#endif
{
  debug_mode = mode;
}

/*++ **********************  function DebugMode ***************

	Purpose:  determine the current debug mode

	Return Values: BitMask

******************************************************************* ++*/

#ifdef VANSI_1
BitMask
DebugMode (void)
#else
BitMask
DebugMode ()
#endif
{
  return debug_mode;
}

/*++ **********************  function SetRecoveryMode ***************

	Purpose: set the recover mode to a specific value

	Return Values:void

******************************************************************* ++*/
#ifdef VANSI_1
void
SetRecoveryMode (BitMask mode)
#else
void
SetRecoveryMode (mode)
     BitMask mode;

#endif
{
  recover_mode = mode;
}

/*++ **********************  function RecoveryMode ***************

	Purpose:  determine the current recover mode

	Return Values: BitMask

******************************************************************* ++*/

#ifdef VANSI_1
BitMask
RecoveryMode (void)
#else
BitMask
RecoveryMode ()
#endif
{
  return recover_mode;
}
