/*
 * db2conv
 *
 * utility that converts an EXE file linked against DB2CLI.DLL (IBM's DB2/2
 * CLI) for use with the LIBCLI.DLL (mSQL's CLI).
 *
 * note: There is only the possibility to convert files from DB2/2 to
 *       mSQL, but not the other way. Maybe a later version of mSQL's CLI
 *       and db2conv can handle this reverse way ...
 *
 * (c) 1996 by Dirk Ohme, all rights reserved
 */

/*---| defines |-------------------------------------------------------------*/
#define PRG_STRING      "DB2Conv V 1.0 - (c) 1996 by Dirk Ohme"

/*---| includes (common) |---------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/*-----------------------------------------------------------------------------
 * main
 *-----------------------------------------------------------------------------
 * function: main procedure
 * input:    int argc
 *             number of command line parameters
 *           char *argv[]
 *             pointer to list of command line parameters
 * output:   int
 *              < 0 - severe error
 *             == 0 - no error
 *              > 0 - warning
 *-----------------------------------------------------------------------------
 */
int main( int argc, char *argv[] )
{ /*---| variables |---*/
  int               cbBuffer           = 0;      /* number of bytes read     */
  int               ci                 = 0;      /* index counter            */
  int               iRC                = 0;      /* return code              */
  FILE             *pInFile            = NULL;   /* input file handle        */
  FILE             *pOutFile           = NULL;   /* output file handle       */
  char              szBuffer[8192]     = "";     /* input line buffer        */

  /*---| program |---*/
  /*
  ** program notification
  */
  fprintf( stderr, "%s\n\n", PRG_STRING );

  /*
  ** check parameters
  */
  if( 3 > argc )
  { fprintf( stderr, "\nsyntax error!\a\n" );
    fprintf( stderr, "syntax: db2conv <old_exe> <new_exe>\n" );
    fprintf( stderr, "  <old_exe> - name of binary linked against DB2/2\n" );
    fprintf( stderr, "  <new_exe> - name of file to be created\n" );
    return (iRC = -1);                          /* -1 == parameter error    */
  } /* if */

  /*
  ** open files
  */
  if( NULL == (pInFile =fopen(argv[1], "rb")) ||
      NULL == (pOutFile=fopen(argv[2], "wb")) )
  { fprintf( stderr, "either input or output file cannot be accessed!\n" );
    return (iRC = -2);                           /* -2 == file error        */
  } /* if */

  /*
  ** check for DB2/2 signature and change it
  */
  printf( "processing '%s' -> '%s' ...\n", argv[1], argv[2] );
  if( !feof(pInFile) )
  { cbBuffer = fread( &szBuffer[0], sizeof(char), sizeof(szBuffer), pInFile );
    for( ci = 0; ci < cbBuffer; ci++ )
    { if(  6  == szBuffer[ci  ] &&
          'D' == szBuffer[ci+1] &&
          'B' == szBuffer[ci+2] &&
          '2' == szBuffer[ci+3] &&
          'C' == szBuffer[ci+4] &&
          'L' == szBuffer[ci+5] &&
          'I' == szBuffer[ci+6] )
      { szBuffer[ci+1] = 'L';
        szBuffer[ci+2] = 'I';
        szBuffer[ci+3] = 'B';
        printf( "DB/2 signature found at $%08X and changed\n", ci );
        ci = cbBuffer;
      }
    } /* for */
    fwrite( &szBuffer[0], sizeof(char), cbBuffer, pOutFile );
  } /* if */

  /*
  ** copy rest of file
  */
  while( !feof(pInFile) )
  { cbBuffer = fread( &szBuffer[0], sizeof(char), sizeof(szBuffer), pInFile );
    fwrite( &szBuffer[0], sizeof(char), cbBuffer, pOutFile );
  } /* while */

  /*
  ** end
  */
  printf( "done.\n" );
  fclose( pInFile );
  fclose( pOutFile );
  return (iRC = 0);

} /* main */

/*===| end of file |=========================================================*/
