/* $Id: DBIXS.h,v 1.19 1995/06/22 00:02:19 timbo Rel $
 *
 * Copyright (c) 1994, Tim Bunce
 *
 * You may distribute under the terms of either the GNU General Public
 * License or the Artistic License, as specified in the Perl README file.
 */

/* DBI Interface Definitions for DBD Modules */

/* first pull in the standard Perl header files for extensions */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"


/* The DBIAPI_VERSION value will be incremented whenever new code is	*/
/* added to the interface (this file). It's primary goal is to allow	*/
/* newer drivers to compile against an old DBI. This is mainly an issue	*/
/* whilst the API grows and learns from the needs of various drivers.	*/
#define DBIAPI_VERSION 4

/* forward declaration, see below */
typedef struct dbih_com_st dbih_com_t;


/* --- DBI State Structure --- */

typedef struct {
    /* version and size are used to check for DBI/DBD version mis-match	*/
    int version;
    int size;

    int debug;
    int debugpvlen;	/* only show dbgpvlen chars when debugging pv's	*/
    FILE *logfp;

    /* pointers to DBI functions which the DBD's will want to use	*/
    dbih_com_t * (*getcom) _((SV *h));	/* see DBIh_COM macro */
    SV         * (*event)  _((SV *h, dbih_com_t*, char *name, SV*, SV*));
    SV *pad1;
    SV *pad2;
    SV *pad3;
    SV *pad4;

} dbistate_t;
#define DBISTATE_VERSION  4	/* Must change whenever dbistate_t does	*/

#define DBISTATE_PERLNAME "DBI::_dbistate"
#define DBISTATE_ADDRSV   (perl_get_sv(DBISTATE_PERLNAME, 0x05))
/* default variable name to use for the dbistate_t variable */
#define DBIS              dbis
#define DBISTATE_DECLARE  static dbistate_t *DBIS

/* Component checks of the DBISTATE_INIT macro defined below		*/
#define DBIS_VERSION_CHECK \
 do {	if (DBIS->version < DBISTATE_VERSION || DBIS->size < sizeof(*DBIS)) \
	  croak("DBI version mismatch (DBI actual v%d/s%d, expected v%d/s%d)", \
	    DBIS->version, DBIS->size, DBISTATE_VERSION, (int)sizeof(*DBIS)); \
 } while(0)

#define DBIS_INIT_DBIS \
 do {	DBIS = (dbistate_t*)SvIV(DBISTATE_ADDRSV); \
	  if (DBIS == NULL) \
	    croak("Unable to get DBI state"); \
 } while(0)

#define DBISTATE_INIT { DBIS_INIT_DBIS; DBIS_VERSION_CHECK; }

#define DBI_INTERNAL_ERROR(msg)	\
	croak("%s: file \"%s\", line %d", msg, __FILE__, __LINE__);

/* #define DBILOGFP	(IoOFP(DBIS->logio)) */
#define DBILOGFP	(DBIS->logfp)


/* --- DBI Handle Common Data Structure (all handles have one) --- */

struct dbih_com_st {
    int  version;	/* version of DBI the DBD was compiled against	*/
    SV   *h;		/* inner handle (copy of outer mg->mg_obj)	*/

    HV   *imp_stash;
    SV   *imp_datarv;	/* RV to implementors SV value (often an IV)	*/
    void *imp_dataptr;	/* == SvIV(SvRV(imp_datarv)) */
    SV   *parent;	/* A real handle RV (refcnt was incremented)	*/
    char *last_method;	/* name of last method called, set by dispatch	*/

    /* these are refs to the Hash values */
    SV *Debug_rv;
    SV *Err_rv;
    SV *Errstr_rv;
    SV *Handlers_rv;

    long pad[4];	/* simple protection against version mismatch	*/
};



/* Macros to access Handle Common Data Structure: */
#ifdef IN_DBI_XS
#define DBIh_COM(h)         (dbih_getcom(h))
#else
#define DBIh_COM(h)         ((DBIS)->getcom(h))
#endif

/* the default variable name to use for local dbih_com_t */
#define DBIHCOM        dbihcom
#define D_dbihcom(h)   dbih_com_t *DBIHCOM=DBIh_COM(h)

/* define handy shortcuts */
#define DBIh_DEBUG  SvIV(SvRV(DBIHCOM->Debug_rv))



/* --- Implementors Private Data Support --- */

/* implementor needs to define actual struct * { ... }	*/
typedef struct imp_drh_st imp_drh_t;	/* driver		*/
typedef struct imp_dbh_st imp_dbh_t;	/* database		*/
typedef struct imp_sth_st imp_sth_t;	/* statement	*/
typedef struct imp_fbh_st imp_fbh_t;	/* field buffer	EXPERIMENTAL		*/

#define D_impdata(name,type)  type *name=(DBIHCOM)->imp_dataptr
#define D_imp_drh D_impdata(imp_drh, imp_drh_t)
#define D_imp_dbh D_impdata(imp_dbh, imp_dbh_t)
#define D_imp_sth D_impdata(imp_sth, imp_sth_t)


/* --- Event Support (VERY LIABLE TO CHANGE) --- */

#define DBIh_EVENTx(h,t,a1,a2)	(DBIS->event((h), DBIHCOM, (t), (a1), (a2)))
#define DBIh_EVENT0(h,t)	DBIh_EVENTx((h), (t), &sv_undef, &sv_undef)
#define DBIh_EVENT1(h,t, a1)	DBIh_EVENTx((h), (t), (a1),      &sv_undef)
#define DBIh_EVENT2(h,t, a1,a2)	DBIh_EVENTx((h), (t), (a1),      (a2))

#define ERROR_event	"ERROR"
#define WARN_event	"WARN"


/* end of DBIXS.h */
