/*
   dbview.c  : mSQL database structure view utility
               version 0.6.3 March, 6th 1996
               (C) 1996 Gian Paolo Ciceri
               gp.ciceri@pn.itnet.it

 Usage: dbview [-h host] database [-t table]
*/
#include <stdio.h>
#include <stdlib.h>
#include "msql.h"

void usage(void);
void close_conn(int sock);
void print_fields(int sock, char *table);
char *decode_type(int type);
char *decode_flags(int flag);
int main(int argc, char *argv[]);

void usage(void)
{

  (void)fprintf(stderr,"\n\nUsage : dbview [-h host] database [-t table]\n\n");
  exit(-3);
}

void close_conn(int sock)
{
  /* close connection */
  msqlClose(sock);
  printf("\nsocket %d closed.\n", sock);
}

void print_fields(int sock, char *table)
{
  m_result *FieldList;
  m_field *FieldInfo;
  int j;
  int numfields = 0;
  FieldList = msqlListFields(sock, table);
  msqlFieldSeek(FieldList, 0);  
  FieldInfo = msqlFetchField(FieldList);
  for (j = 1; (FieldInfo != NULL); j++ )
    {
      printf("\nFieldName: %s", FieldInfo->name);
      printf("\nType     : %s", decode_type(FieldInfo->type));  
      printf("\nLength   : %i", FieldInfo->length);
      printf("\nFlags    : %s\n", decode_flags(FieldInfo->flags));
      msqlFieldSeek(FieldList, j);
      FieldInfo = msqlFetchField(FieldList);
      ++numfields;
    }
  if (numfields == 0) printf("\nNo Columns found for Table '%s': perhaps table does not exist.\n", table);
  msqlFreeResult(FieldList);
}


char *decode_type(int type)
{
  if (type == INT_TYPE)  return("INT ");
  if (type == CHAR_TYPE) return("CHAR");
  if (type == REAL_TYPE) return("REAL");
}

char *decode_flags(int flag)
{
  if ( !IS_PRI_KEY(flag) && !IS_NOT_NULL(flag) ) return("");
  if ( IS_PRI_KEY(flag)  && !IS_NOT_NULL(flag) ) return("PRI_KEY");
  if ( !IS_PRI_KEY(flag) && IS_NOT_NULL(flag)  ) return("NOT_NULL");
  if ( IS_PRI_KEY(flag)  && IS_NOT_NULL(flag)  ) return("PRI_KEY NOT_NULL");
}

main(int argc, char *argv[]) 
{
char *version = "0.6.3";
char *hostname = NULL;
char *dbname  = NULL;
char *tabname = NULL;
int conn_sock;
int conn_db;
m_result *TableList;
m_result *FieldList;
m_field *FieldInfo;
int NumTab;
int NumField;
m_row TabInfo;
int i;
int j;

/* Step 0: parse arguments     */
switch( argc )
  {
  case 2:
      hostname = (char *)getenv("HOSTNAME");
      dbname   = argv[1];
      break;
  case 4:
/*      if (strcmp(argv[1],"-h")) usage();
      hostname = argv[2];
      dbname   = argv[3];
      break;
*/
      if (!strcmp(argv[1],"-h"))
	{
	 hostname = argv[2];
         dbname   = argv[3]; 
	 break;
       }
      if (!strcmp(argv[2],"-t"))
	{
         hostname = (char *)getenv("HOSTNAME");
	 tabname = argv[3];
         dbname   = argv[1]; 
	 break;
       } 
      usage();
  case 6:
      if (strcmp(argv[1],"-h") || strcmp(argv[4],"-t")) usage();
      hostname = argv[2];
      dbname   = argv[3];
      tabname  = argv[5];
      break;
  default:
      usage();
  }

/* Step 1: get connection      */

/* open connection             */
if ((conn_sock = msqlConnect(hostname)) < 0)
{   
  printf("ERROR : %s\n", msqlErrMsg);
  exit(1);
}
  printf("\n - dbview %s -", version);
  printf("\n\nConnection Info:\n");
  printf("\nConnected to Server: %s\t socket %d open", hostname, conn_sock);

/* select database & table          */
if ((conn_db = msqlSelectDB(conn_sock, dbname))< 0) 
{
  printf("\nERROR: Unable to connect to DB: '%s'\t", dbname);
  printf("\nReturn Code : \t %i\n", conn_db); 
  return 0;
}
  printf("\nDB selected        : %s", dbname);
  printf("\nTable selected     : %s", tabname);

/* end of Step 1               */

/* Step 2: get tables          */
/* get table list              */
if (tabname == NULL)
{
  TableList = msqlListTables(conn_sock);

  /* get the number of tables in DB */
  NumTab = msqlNumRows(TableList);
  printf("\n\nTable Info:\n");
  printf("\nNumber of Tables in DB %s:   %d\t", dbname, NumTab);

  /* exit if there are no tables */
  if (NumTab == 0) 
    {
      close_conn(conn_sock);
      return 0;
    }  

  /* get the table names */

  printf("\nTable Names for DB %s\n", dbname);
  for(i = 0; i < NumTab; i++)
    { 
      msqlDataSeek(TableList, i);
      TabInfo = msqlFetchRow(TableList);
      printf("Table #%d: %s\t\n", i+1, TabInfo[0]);
    }
}

/* end of Step 2               */

/* Step 3: get tables          */
/* get table details           */
printf("\n\nColumn Info:\n");
if( tabname == NULL)
{
  for(i = 0; i < NumTab; i++)
    { 
      msqlDataSeek(TableList, i);  
      TabInfo = msqlFetchRow(TableList);
      printf("\n\nColumns of Table #%i: %s\n", i+1, TabInfo[0]);

      /* get the field names */
      print_fields(conn_sock, TabInfo[0]);
    }
  /* free the result of the query */
  msqlFreeResult(TableList);
}
else
{
 printf("\nColumns of Table : %s\n", tabname);
 print_fields(conn_sock, tabname);
}

/* close connection */
close_conn(conn_sock);

}














