#include <X11/Intrinsic.h>
#include <msql.h>

#define WHITESPACE 3

char *appendString(char *dest, char *src)
{
  while (*src) 
    *dest++ = *src++;
  return dest;
}

char *appendChars(char *dest, char chr, int count)
{
  int i;

  for (i = 0; i < count; i++)
    *dest++ = chr;
  return dest;
}

char *appendWhitespace(char *dest)
{
  *dest++ = ' ';
  return dest;
}

char *appendReturn(char *dest)
{ 
  *dest++ = '\n';
  return dest;
}

char *formattedOutput(m_result *qresult, int numRows)
{
  int i, fieldCount;
  m_row row;
  m_field *field;
  int *lenList, lenSum = 0;
  char *dest, *output;

  fieldCount = msqlNumFields(qresult);
  lenList = (int *)XtMalloc(fieldCount * sizeof(int));
  if (!lenList)
    return NULL;
  for (i = 0; i < fieldCount; i++) {
    field = msqlFetchField(qresult);
    lenList[i] = (field->length > strlen(field->name) ? field->length : strlen(field->name));
    lenSum += (lenList[i] + WHITESPACE);
  }
  /* reset fields-cursor */
  msqlFieldSeek(qresult, 0);
  /* output buffer */
  dest = output = (char *)XtMalloc(lenSum * (numRows+2) * sizeof(char));
  /* create formatted output */
  /* 1. create header */
  for (i = 0; i < fieldCount; i++) {
    field = msqlFetchField(qresult);
    dest = appendString(dest, field->name);
    dest = appendChars(dest, ' ', lenList[i] - strlen(field->name));
    dest = appendWhitespace(dest);
  }
  dest = appendReturn(dest);
  for (i = 0; i < fieldCount; i++) {
    dest = appendChars(dest, '-', lenList[i]);
    dest = appendWhitespace(dest);
  }
  dest = appendReturn(dest);
  /* 2. data */
  while (row = msqlFetchRow(qresult)) {
    for (i = 0; i < fieldCount; i++) {
      dest = appendString(dest, row[i]);
      dest = appendChars(dest, ' ', lenList[i] - strlen(row[i]));
      dest = appendWhitespace(dest);
    }
    dest = appendReturn(dest);
  }
  *dest = '\0';           
  XtFree((char *)lenList);
  return output;
}      

  
