/*********************************************************
*
*	xfsql_sub.c		Mark Loveland
*
*	version .4		4/30/96
*
*********************************************************/
#include "add.h"

void Tables()
{
	m_row current;
	m_result *result;
	int socket;

	if ((socket = msqlConnect(host)) < 0)
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_addto_browser(fd_xfsql->Output3,"ERROR: Unable to connect to host");
		msqlClose(socket);
	}
	else if(msqlSelectDB(socket,database) < 0)
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_addto_browser(fd_xfsql->Output3,"Use cursor and click to select a DB");
		msqlClose(socket);
	}

	result = msqlListTables(socket);

	if (!result)
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_addto_browser(fd_xfsql->Output3,"ERORR: No Tables available");
		msqlClose(socket);
		msqlFreeResult(result);
	}
	else
	{
		fl_clear_browser(fd_xfsql->Output2);
		fl_clear_browser(fd_xfsql->Output3);

		while((current = msqlFetchRow(result)))
		      		fl_addto_browser(fd_xfsql->Output2,current[0]);

		msqlFreeResult(result);
		msqlClose(socket);
	}
}

void Fields()
{
	m_result *result;
	m_field	*current_field;
	int socket,length;
	char 	typeName[10];
	char 	intchar[64];
	char 	buffer[1024];

	if ((socket = msqlConnect(host)) < 0)
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_addto_browser(fd_xfsql->Output3,"ERROR: Unable to connect to host");
		msqlClose(socket);
	}
	else if(msqlSelectDB(socket,database) < 0)
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_addto_browser(fd_xfsql->Output3,"Use cursor and click to select a DB");
		msqlClose(socket);
	}

	result = msqlListFields(socket,table);

	if (!result)
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_addto_browser(fd_xfsql->Output3,"No Fields available for listing");
		msqlClose(socket);
		msqlFreeResult(result);
	}
	else
	{
		fl_clear_browser(fd_xfsql->Output3);

		while((current_field = msqlFetchField(result)))
		{
			strcpy(buffer,current_field->name);
			length = strlen(buffer);
			if (length >7)
				strcat(buffer,"\t");
			else
				strcat(buffer,"\t\t");
			switch(current_field->type)
			{
				case INT_TYPE:
					strcpy(typeName,"int");
					break;
				case CHAR_TYPE:
					strcpy(typeName,"char");
					break;
				case REAL_TYPE:
					strcpy(typeName,"real");
					break;
				default:
					strcpy(typeName,"Unknown");
					break;
			}
			strcat(buffer,typeName);
			strcat(buffer,"\t");
			sprintf(intchar,"%d",current_field->length);
			strcat(buffer,intchar);
			strcat(buffer,"\t");
			strcat(buffer,IS_NOT_NULL(current_field->flags)?"Y":"N");
			strcat(buffer,"\t");
			strcat(buffer,IS_PRI_KEY(current_field->flags)?"Y":"N");
			strcat(buffer,"\t");
			fl_addto_browser(fd_xfsql->Output3,buffer);
		}
		fl_addto_browser(fd_xfsql->Output3,"\n\n");
		msqlFreeResult(result);
		msqlClose(socket); 
	}
}

void Get_Host(char* input)
{
 
 	m_row	current;
	m_result *result;
	int socket;
		
	host = NULL;

	if (strcmp(input,"") != 0)
		host = input;
	
	if ((socket = msqlConnect(host)) < 0)
	{
		fl_clear_browser(fd_xfsql->Output1);
		fl_clear_browser(fd_xfsql->Output2);
		fl_clear_browser(fd_xfsql->Output3);

		fl_addto_browser(fd_xfsql->Output3,"ERROR: Unable to connect to host");
 		msqlClose(socket);
	}
	else
	{
		result = msqlListDBs(socket);
		
		if (!result)
		{
			fl_clear_browser(fd_xfsql->Output1);
			fl_clear_browser(fd_xfsql->Output2);
			fl_clear_browser(fd_xfsql->Output3);

			fl_addto_browser(fd_xfsql->Output3,"ERROR: No Databases available");
			msqlClose(socket);
		}
		else
		{
			strcpy(database,"");
			fl_clear_browser(fd_xfsql->Output1);
			fl_clear_browser(fd_xfsql->Output2);
			fl_clear_browser(fd_xfsql->Output3);

			while((current = msqlFetchRow(result)))
      				fl_addto_browser(fd_xfsql->Output1,current[0]);
			msqlFreeResult(result);
			msqlClose(socket);
		}
	}
}


void fill(buf,length,max,filler)
char *buf;
int length, max;
char *filler;
{
	int	count;

	count = max - length;
	while (count-- >= 1)
	{
		strcat(buf,filler);
	}
}

int max(v1,v2)
int v1,	v2;
{
	if (v1 > v2)
		return(v1);
	else
		return(v2);
}

void showinfo(context)
char *context;
{
	char buf[40];
	strcpy(buf,"../info/");
	strcat(buf,context);
	context = buf;
	fl_clear_browser(fd_xfsql->Output3);
	if (!fl_load_browser(fd_xfsql->Output3,context))
	{
		strcat(buf," file is missing"); 
		fl_add_browser_line(fd_xfsql->Output3,context);
	}
}
