/*********************************************************
*
*	input_form_cb.c		Mark Loveland
*
*	version .4		5/9/96
*
*********************************************************/
#include "add.h"


/* callbacks for form INPUT */
void INPUT_Form_Input_cb(FL_OBJECT *ob, long data)
{
}

void INPUT_Form_Submit_cb(FL_OBJECT *ob, long data)
{ 
	char buffer[256];
	char *input;
	m_result *result_data;
	int sock;
	
	(const)input = fl_get_input(fd_input->INPUT_Form_Input);
	
	if ((sock = msqlConnect(host))< 0)
	{
		fl_set_input(fd_input->INPUT_Form_Input,"ERROR: Unable to connect to host");
 		msqlClose(sock);
	}
	else if (mode == CREATE)
	{
		if(msqlCreateDB(sock,input) < 0)
		{
			fl_set_input(fd_input->INPUT_Form_Input,
			"ERROR: Permission unavailable to you or duplicate name.");
			msqlClose(sock);
		}
		else
		{
			fl_set_input(fd_input->INPUT_Form_Input,"Database Created");
			msqlClose(sock);				
		}
	}
	else if (mode == DROP)
	{
		result_data = msqlListDBs(sock);

		if (!result_data)
		{
			fl_set_input(fd_input->INPUT_Form_Input,"ERROR: No Databases available");
			msqlFreeResult(result_data);
			msqlClose(sock);
		}		
		else if (msqlSelectDB(sock,database) < false)
		{
			fl_clear_browser(fd_xfsql->Output3);
			fl_set_input(fd_input->INPUT_Form_Input,"Database not found, perhaps misspelled");
			msqlFreeResult(result_data);
			msqlClose(sock);
		}
		else if(msqlDropDB(sock,database) < 0)
		{
			fl_clear_browser(fd_xfsql->Output3);
			strcpy(buffer,"ERROR: ");
			strcat(buffer,msqlErrMsg); 
			fl_add_browser_line(fd_xfsql->Output3,buffer);
			msqlClose(sock);
			msqlFreeResult(result_data);
		}
		else
		{
			fl_clear_browser(fd_xfsql->Output3);
			fl_add_browser_line(fd_xfsql->Output3,"Database Dropped");
			msqlClose(sock);
			msqlFreeResult(result_data);
		}

	}
}

void INPUT_Form_Exit_cb(FL_OBJECT *ob, long data)
{
  	fl_hide_form(fd_input->INPUT);
}

void INPUT_Form_Clear_cb(FL_OBJECT *ob, long data)
{
	fl_set_input(fd_input->INPUT_Form_Input,"");
}


