//#define DEBUG
#define PLATFORM_MSWINDOWS
#include "zapp.h"
#include "winmsql.rh"
#include <stdio.h>
#include <dir.h>
#include <winsock.h>
#include "zmsql.h"
#include <ctype.h>

#define MAX_SQL_LENGTH	10000
class ZNewWindow;
ZNewWindow* MainWin;
ZmSQLConnection* DB;
ZmSQL* sql;

char dfld[MAX_SQL_LENGTH];

BOOL FAR PASCAL SQLDlgProc(HWND,unsigned,WORD,LONG);
BOOL FAR PASCAL DBDlgProc(HWND,unsigned,WORD,LONG);
BOOL FAR PASCAL SvrDlgProc(HWND,unsigned,WORD,LONG);

class ZNewWindow : public ZWindow	{
	public:
		int NetErr;
		ZNewWindow(TZWindow Parent,char* title,ZMenu* menu);
		~ZNewWindow();
		virtual LRESULT CmAbout(ZEventInfo);
		virtual LRESULT HandleEvent(ZEventInfo);
		};

ZNewWindow::ZNewWindow(TZWindow Parent,char* title,ZMenu* menu):
	ZWindow(Parent,title,menu,10,10,300,100)
{
char buf[100];
WSADATA wsadata;
if(WSAStartup(0x0101,&wsadata))	{
	MessageBox(NULL,"Error starting TCP/IP","WSAStartup",MB_OK);
	}
DB=new ZmSQLConnection();
sql=new ZmSQL(DB);
}

ZNewWindow::~ZNewWindow()
{
delete sql;
delete DB;
WSACleanup();
}


LRESULT ZNewWindow::HandleEvent(ZEventInfo Event)
{
DLGPROC lpSQLDlgProc;
DLGPROC lpDBDlgProc;
DLGPROC lpSvrDlgProc;
char buf[100];

switch(Event.message)	{
	case WM_CREATE:
		wsprintf(buf,"Win mSQL - %s:%s",DB->Server,DB->DBName);
		SetTitle(buf);
		return ZWindow::HandleEvent(Event);
	case WM_COMMAND:
		switch(Event.wParam)	{
			case CM_ABOUT:
				CmAbout(Event);
				break;
			case CM_EXIT:
				CmQuit(Event);
				break;
			case CM_DATABASE_SEND_QUERY:
//				lpSQLDlgProc=(DLGPROC)MakeProcInstance((FARPROC)SQLDlgProc,Main.hInstance);
				DialogBox(Main.hInstance,"SQLDlg",Window,(DLGPROC)SQLDlgProc);
//				FreeProcInstance((FARPROC)lpSQLDlgProc);
				break;
			case CM_DATABASESELECT_DATABASE:
//				lpDBDlgProc=(DLGPROC)MakeProcInstance((FARPROC)DBDlgProc,Main.hInstance);
				DialogBox(Main.hInstance,"DBDlg",Window,(DLGPROC)DBDlgProc);
//				FreeProcInstance((FARPROC)lpDBDlgProc);
				break;
			case CM_DATABASESELECT_SERVER:
//				lpSvrDlgProc=(DLGPROC)MakeProcInstance((FARPROC)SvrDlgProc,Main.hInstance);
				DialogBox(Main.hInstance,"SvrDlg",Window,(DLGPROC)SvrDlgProc);
//				FreeProcInstance((FARPROC)lpSvrDlgProc);
				break;

			}
		break;
	default:
		return ZWindow::HandleEvent(Event);
	}
return 0;
}

#pragma argsused
LRESULT ZNewWindow::CmAbout(ZEventInfo Ev)
{
char buf[1000]="Win mSQL 1.0.7\nWindows client by Dean Fuqua (fuqua@niehs.nih.gov)\n"
					"mSQL API by David Hughes";
MessageBox(Window,buf,"Win mSQL 1.0.7",MB_OK|MB_ICONINFORMATION);
return 1;
}


ZMain()
{
ZMenu Menu("WinmSQLMenu");
ZNewWindow Win(NULL,"Win mSQL 1.0.7",&Menu);
ZApp App(&Win,"Win mSQL 1.0.7");
MainWin=&Win;
App.Run();
return 0;
}

#pragma argsused
BOOL FAR PASCAL SQLDlgProc(HWND hDlg,unsigned message,WORD wParam ,LONG lParam)
{
static char SQL[1000]="";
char SQLtemp[1000]="";
static HWND hSQL;
static ZNewWindow* Par;
DWORD ti;
int i,x;
char temp[1024];
FILE* fp;
struct ffblk ffblk;
int done;
int SQLId=0;
char FName[128];
char Comm[128];
char* DotPos;

switch(message)	{
	case WM_INITDIALOG:
		hSQL=GetDlgItem(hDlg,IDC_SQL);
		SetWindowText(hSQL,SQL);
		SetFocus(hSQL);
		Par=MainWin;
		return FALSE;

	case WM_COMMAND:
		switch(wParam)	{
			case IDOK:
				GetWindowText(hSQL,SQL,sizeof(SQL)-1);
				if(sql->Open(SQL)) {
					done = findfirst("results\\*.",&ffblk,0);
					while (!done)	{
						if(atoi(ffblk.ff_name)>SQLId)
							SQLId=atoi(ffblk.ff_name);
						done = findnext(&ffblk);
						}
					wsprintf(FName,"results\\%d.",SQLId+1);
					if(!(fp=fopen(FName,"w")))	{
						MessageBox(Par->Window,FName,"Cannot open file:",MB_ICONINFORMATION|MB_OK);
						return TRUE;
						}
					x=0;
					while(sql->GetNextRecord())	{
						x++;
						for(i=0;i<sql->GetNumCols();i++)	{
							sql->GetSQLData(i,dfld,MAX_SQL_LENGTH-1);
							fprintf(fp,"%s\t",dfld);
							}
						fprintf(fp,"\n");
						}
					fclose(fp);
					if(x)	{
						wsprintf(Comm,"write %s",FName);
						WinExec(Comm,SW_SHOW);
						}
					else	{
						x=0;
						while(SQL[x])	{
							SQLtemp[x]=toupper(SQL[x]);
							x++;
							}
						if(!strstr(SQLtemp,"SELECT"))
							MessageBox(NULL,"SQL transaction complete","SQL:",MB_ICONINFORMATION|MB_OK);
						else
							MessageBox(NULL,"No results found","SQL:",MB_ICONINFORMATION|MB_OK);
						}
					}
				EndDialog(hDlg,1);
				return TRUE;
			case IDCANCEL:
				EndDialog(hDlg,0);
				return TRUE;
			default:
				return FALSE;
			}
	default:
		return FALSE;
	}
}
#pragma argsused
BOOL FAR PASCAL DBDlgProc(HWND hDlg,unsigned message,WORD wParam ,LONG lParam)
{
static HWND hDB;
static ZNewWindow* Par;
int i;
char dfld[100];
static char DBList[10][20];
char *bptr;
char wintit[100];

switch(message)	{
	case WM_INITDIALOG:
		hDB=GetDlgItem(hDlg,IDC_DB);
		SetFocus(hDB);
		Par=MainWin;
		for(i=0;i<10;i++)	{
			bptr=DB->GetDBName(i);
			if(bptr)	{
				strcpy(DBList[i],bptr);
				SendMessage(hDB,LB_ADDSTRING,0,(LPARAM)(LPCSTR)DBList[i]);
				if(!strcmp(DBList[i],DB->Server))
					SendMessage(hDB,LB_SETCURSEL,(WPARAM)i,0L);
				}
			}
		return FALSE;
	case WM_COMMAND:
		switch(wParam)	{
			case IDOK:
				i=SendMessage(hDB,LB_GETCURSEL,0,0L);
				if(i==LB_ERR)	{
					MessageBox(Par->Window,"You must select a Database...","Hey!",MB_OK|MB_ICONINFORMATION);
					break;
					}
				DB->SetDB(DBList[i]);
				strcpy(DB->DBName,DBList[i]);
				wsprintf(wintit,"Win mSQL 1.0.7 - %s:%s",DB->Server,DB->DBName);
				SetWindowText(Par->Window,wintit);
				EndDialog(hDlg,1);
				return TRUE;
			case IDCANCEL:
				EndDialog(hDlg,0);
				return TRUE;
			default:
				return FALSE;
			}
	default:
		return FALSE;
	}
}

#pragma argsused
BOOL FAR PASCAL SvrDlgProc(HWND hDlg,unsigned message,WORD wParam ,LONG lParam)
{
static HWND hSvr;
static ZNewWindow* Par;
char buf[100];

switch(message)	{
	case WM_INITDIALOG:
		hSvr=GetDlgItem(hDlg,IDC_SVR);
		SetFocus(hSvr);
		Par=MainWin;
		SetWindowText(hSvr,DB->Server);
		return FALSE;
	case WM_COMMAND:
		switch(wParam)	{
			case IDOK:
				GetWindowText(hSvr,buf,sizeof(buf));
				DB->SetServer(buf);
				wsprintf(buf,"Win mSQL - %s:%s",DB->Server,DB->DBName);
				SetWindowText(Par->Window,buf);
				EndDialog(hDlg,1);
				return TRUE;
			case IDCANCEL:
				EndDialog(hDlg,0);
				return TRUE;
			default:
				return FALSE;
			}
	default:
		return FALSE;
	}
}

